/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kms.client.json.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class KMSSchedulerResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private KMSScheduler scheduler = null;

    public KMSScheduler getScheduler() {
        return this.scheduler;
    }

    public List<String> getQueueNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.scheduler != null) {
            this.scheduler.collectQueueNames(ret);
        }
        return ret;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class KMSQueues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<KMSSchedulerInfo> queue = null;

        public List<KMSSchedulerInfo> getQueue() {
            return this.queue;
        }

        public void collectQueueNames(List<String> queueNames, String parentQueueName) {
            if (this.queue != null) {
                for (KMSSchedulerInfo schedulerInfo : this.queue) {
                    schedulerInfo.collectQueueNames(queueNames, parentQueueName);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class KMSSchedulerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String queueName = null;
        private KMSQueues queues = null;

        public String getQueueName() {
            return this.queueName;
        }

        public KMSQueues getQueues() {
            return this.queues;
        }

        public void collectQueueNames(List<String> queueNames, String parentQueueName) {
            if (this.queueName != null) {
                String queueFqdn = parentQueueName == null ? this.queueName : parentQueueName + "." + this.queueName;
                queueNames.add(queueFqdn);
                if (this.queues != null) {
                    this.queues.collectQueueNames(queueNames, queueFqdn);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class KMSScheduler
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private KMSSchedulerInfo schedulerInfo = null;

        public KMSSchedulerInfo getSchedulerInfo() {
            return this.schedulerInfo;
        }

        public void collectQueueNames(List<String> queueNames) {
            if (this.schedulerInfo != null) {
                this.schedulerInfo.collectQueueNames(queueNames, null);
            }
        }
    }
}

