/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.conf;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="ozone.service")
public class OzoneServiceConfig {
    public static final long OZONE_SHUTDOWN_TIMEOUT_MINIMUM = 1L;
    public static final TimeUnit OZONE_SHUTDOWN_TIME_UNIT_DEFAULT = TimeUnit.SECONDS;
    public static final int DEFAULT_SHUTDOWN_HOOK_PRIORITY = 10;
    public static final String SERVICE_SHUTDOWN_TIMEOUT = "shutdown.timeout";
    public static final String SERVICE_SHUTDOWN_TIMEOUT_DEFAULT = "60s";
    @Config(key="shutdown.timeout", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.OM, ConfigTag.SCM, ConfigTag.DATANODE, ConfigTag.RECON, ConfigTag.S3GATEWAY}, timeUnit=TimeUnit.SECONDS, description="Timeout to wait for each shutdown operation to completeIf a hook takes longer than this time to complete, it will be interrupted, so the service will shutdown. This allows the service shutdown to recover from a blocked operation. The minimum duration of the timeout is 1 second, if hook has been configured with a timeout less than 1 second.")
    private long serviceShutdownTimeout = 60L;

    public long getServiceShutdownTimeout() {
        return this.serviceShutdownTimeout;
    }

    public void setServiceShutdownTimeout(long serviceShutdownTimeout) {
        this.serviceShutdownTimeout = serviceShutdownTimeout;
    }
}

