/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.kms.metrics.collector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.thirdparty.com.google.common.base.Stopwatch;
import org.apache.ranger.kms.metrics.KMSMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSMetricsCollector {
    static final Logger logger = LoggerFactory.getLogger(KMSMetricsCollector.class);
    private static volatile KMSMetricsCollector kmsMetricsCollector;
    private final boolean isCollectionThreadSafe;
    private final Map<KMSMetrics.KMSMetric, Long> metrics = new HashMap<KMSMetrics.KMSMetric, Long>();

    private KMSMetricsCollector(boolean isCollectionThreadSafe) {
        this.isCollectionThreadSafe = isCollectionThreadSafe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KMSMetricsCollector getInstance(boolean isCollectionThreadSafe) {
        KMSMetricsCollector metricsCollector = kmsMetricsCollector;
        if (metricsCollector != null) return metricsCollector;
        Class<KMSMetricsCollector> clazz = KMSMetricsCollector.class;
        synchronized (KMSMetricsCollector.class) {
            metricsCollector = kmsMetricsCollector;
            if (metricsCollector != null) return metricsCollector;
            kmsMetricsCollector = metricsCollector = new KMSMetricsCollector(isCollectionThreadSafe);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return metricsCollector;
        }
    }

    public boolean isCollectionThreadSafe() {
        return this.isCollectionThreadSafe;
    }

    public Map<KMSMetrics.KMSMetric, Long> getMetricsMap() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public void incrementCounter(KMSMetrics.KMSMetric metric) {
        if (this.isCollectionThreadSafe) {
            if (KMSMetrics.Type.COUNTER.equals((Object)metric.getType())) {
                metric.incrementCounter();
            } else {
                logger.warn("Only Counter metric can be incremented. Current metric type is {}", (Object)metric.getType());
            }
        } else {
            this.metrics.compute(metric, (k, v) -> null == v ? 1L : v + 1L);
        }
    }

    public void updateMetric(KMSMetrics.KMSMetric metric, long val) {
        if (this.isCollectionThreadSafe) {
            metric.updateValue(val);
        } else {
            this.metrics.compute(metric, (k, v) -> null == v ? val : v + val);
        }
    }

    public APIMetric createAPIMetric(KMSMetrics.KMSMetric counter, KMSMetrics.KMSMetric elapsedTime) {
        return new APIMetric(counter, elapsedTime);
    }

    public APIMetric captureElapsedTime() {
        return new APIMetric();
    }

    public class APIMetric
    implements AutoCloseable {
        private KMSMetrics.KMSMetric counter;
        private KMSMetrics.KMSMetric elapsedTime;
        private final Stopwatch sw = Stopwatch.createStarted();

        private APIMetric(KMSMetrics.KMSMetric counter, KMSMetrics.KMSMetric elapsedTime) {
            this();
            this.counter = counter;
            this.elapsedTime = elapsedTime;
        }

        private APIMetric() {
        }

        public void setMetrics(KMSMetrics.KMSMetric counter, KMSMetrics.KMSMetric elapsedTime) {
            this.counter = counter;
            this.elapsedTime = elapsedTime;
        }

        @Override
        public void close() {
            if (null != this.counter && null != this.elapsedTime) {
                KMSMetricsCollector.this.incrementCounter(this.counter);
                KMSMetricsCollector.this.updateMetric(this.elapsedTime, this.sw.stop().elapsed(TimeUnit.MILLISECONDS));
            } else {
                long elapsedTime = this.sw.stop().elapsed(TimeUnit.MILLISECONDS);
                logger.warn("API metric started to capture elapsed time but Elapsed metric was not set. Elapsed time(in MS) {}", (Object)elapsedTime);
            }
        }
    }
}

