/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.kms.dao;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.apache.ranger.entity.XXRangerKeyStore;
import org.apache.ranger.kms.dao.BaseDao;
import org.apache.ranger.kms.dao.DaoManagerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKMSDao
extends BaseDao<XXRangerKeyStore> {
    private static final Logger logger = LoggerFactory.getLogger(RangerKMSDao.class);
    private static final String GET_ALL_KEYS_QUERY_NAME = "XXRangerKeyStore.getAllKeys";

    RangerKMSDao(DaoManagerBase daoManager) {
        super(daoManager);
    }

    public XXRangerKeyStore findByAlias(String alias) {
        return (XXRangerKeyStore)super.findByAlias("XXRangerKeyStore.findByAlias", alias);
    }

    public int deleteByAlias(String alias) {
        return super.deleteByAlias("XXRangerKeyStore.deleteByAlias", alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XXRangerKeyStore> getAllKeys() {
        ArrayList<XXRangerKeyStore> ret = null;
        EntityManager em = null;
        try {
            em = this.getEntityManager();
            List rows = em.createNamedQuery(GET_ALL_KEYS_QUERY_NAME).setHint("eclipselink.refresh", (Object)"true").getResultList();
            if (rows != null) {
                ret = new ArrayList<XXRangerKeyStore>(rows.size());
                for (Object[] row : rows) {
                    XXRangerKeyStore key = new XXRangerKeyStore();
                    key.setId((Long)row[0]);
                    key.setAlias((String)row[1]);
                    key.setCreatedDate((Long)row[2]);
                    key.setEncoded((String)row[3]);
                    key.setCipher((String)row[4]);
                    key.setBitLength((Integer)row[5]);
                    key.setDescription((String)row[6]);
                    key.setVersion((Integer)row[7]);
                    key.setAttributes((String)row[8]);
                    ret.add(key);
                }
            }
        }
        catch (NoResultException e) {
            logger.error("getAllKeys({}) failed", (Object)GET_ALL_KEYS_QUERY_NAME, (Object)e);
        }
        finally {
            if (em != null) {
                em.clear();
            }
        }
        return ret;
    }
}

