/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/

// eslint-disable-next-line import/no-anonymous-default-export
export default {
  "amqp:/_topo/0/A/$management": {
    "router.node": {
      results: [
        ["A", 0],
        ["B", 1]
      ],
      attributeNames: ["id", "index"]
    },
    log: {
      results: [
        [
          "HTTP",
          null,
          null,
          null,
          null,
          "log/HTTP",
          "log/HTTP",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER_LS",
          null,
          null,
          null,
          null,
          "log/ROUTER_LS",
          "log/ROUTER_LS",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "DEFAULT",
          "info+",
          true,
          false,
          "stderr",
          "log/DEFAULT",
          "log/DEFAULT",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "PYTHON",
          null,
          null,
          null,
          null,
          "log/PYTHON",
          "log/PYTHON",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER_MA",
          null,
          null,
          null,
          null,
          "log/ROUTER_MA",
          "log/ROUTER_MA",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "CONN_MGR",
          null,
          null,
          null,
          null,
          "log/CONN_MGR",
          "log/CONN_MGR",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER_HELLO",
          null,
          null,
          null,
          null,
          "log/ROUTER_HELLO",
          "log/ROUTER_HELLO",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "SERVER",
          null,
          null,
          null,
          null,
          "log/SERVER",
          "log/SERVER",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "POLICY",
          null,
          null,
          null,
          null,
          "log/POLICY",
          "log/POLICY",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "CONTAINER",
          null,
          null,
          null,
          null,
          "log/CONTAINER",
          "log/CONTAINER",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "AGENT",
          null,
          null,
          null,
          null,
          "log/AGENT",
          "log/AGENT",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ERROR",
          null,
          null,
          null,
          null,
          "log/ERROR",
          "log/ERROR",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER_CORE",
          null,
          null,
          null,
          null,
          "log/ROUTER_CORE",
          "log/ROUTER_CORE",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER",
          null,
          null,
          null,
          null,
          "log/ROUTER",
          "log/ROUTER",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "MESSAGE",
          null,
          null,
          null,
          null,
          "log/MESSAGE",
          "log/MESSAGE",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "AUTHSERVICE",
          null,
          null,
          null,
          null,
          "log/AUTHSERVICE",
          "log/AUTHSERVICE",
          "org.apache.qpid.dispatch.log"
        ]
      ],
      attributeNames: [
        "module",
        "enable",
        "includeTimestamp",
        "includeSource",
        "outputFile",
        "name",
        "identity",
        "type"
      ]
    },
    logStats: {
      results: [
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "DEFAULT",
          "logStats/DEFAULT",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "ERROR",
          "logStats/ERROR",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "PYTHON",
          "logStats/PYTHON",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "MESSAGE",
          "logStats/MESSAGE",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "MAIN",
          "logStats/MAIN",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          1874,
          1,
          0,
          0,
          0,
          0,
          "AGENT",
          "logStats/AGENT",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          2,
          0,
          0,
          0,
          0,
          "POLICY",
          "logStats/POLICY",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "HTTP",
          "logStats/HTTP",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          191,
          0,
          8,
          0,
          0,
          0,
          0,
          "ROUTER_LS",
          "logStats/ROUTER_LS",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          1,
          0,
          0,
          0,
          0,
          0,
          0,
          "ROUTER_MA",
          "logStats/ROUTER_MA",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          3,
          0,
          0,
          0,
          0,
          "CONN_MGR",
          "logStats/CONN_MGR",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          5344,
          0,
          0,
          0,
          0,
          0,
          0,
          "ROUTER_HELLO",
          "logStats/ROUTER_HELLO",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          16,
          4,
          0,
          0,
          0,
          "SERVER",
          "logStats/SERVER",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "CONTAINER",
          "logStats/CONTAINER",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "ROUTER_CORE",
          "logStats/ROUTER_CORE",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          6,
          1,
          75,
          0,
          0,
          0,
          0,
          "ROUTER",
          "logStats/ROUTER",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "AUTHSERVICE",
          "logStats/AUTHSERVICE",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "DISPLAYNAME",
          "logStats/DISPLAYNAME",
          "org.apache.qpid.dispatch.logStats"
        ]
      ],
      attributeNames: [
        "traceCount",
        "debugCount",
        "infoCount",
        "noticeCount",
        "warningCount",
        "errorCount",
        "criticalCount",
        "name",
        "identity",
        "type"
      ]
    },
    router: {
      attributeNames: [
        "name",
        "identity",
        "id",
        "type",
        "mode",
        "area",
        "version",
        "addrCount",
        "linkCount",
        "nodeCount",
        "linkRouteCount",
        "autoLinkCount",
        "connectionCount",
        "presettledDeliveries",
        "droppedPresettledDeliveries",
        "acceptedDeliveries",
        "rejectedDeliveries",
        "releasedDeliveries",
        "modifiedDeliveries",
        "deliveriesDelayed1Sec",
        "deliveriesDelayed10Sec",
        "deliveriesIngress",
        "deliveriesEgress",
        "deliveriesTransit",
        "deliveriesIngressRouteContainer",
        "deliveriesEgressRouteContainer",
        "deliveriesRedirectedToFallback"
      ],
      results: [
        [
          "A",
          "1",
          "A",
          "org.apache.qpid.dispatch.router",
          "interior",
          "0",
          "1.9.0-SNAPSHOT",
          13,
          25,
          1,
          0,
          0,
          3,
          0,
          0,
          31493,
          0,
          0,
          0,
          90,
          26130,
          31743,
          5248,
          29007,
          0,
          0,
          0
        ]
      ]
    },
    connection: {
      attributeNames: [
        "name",
        "identity",
        "host",
        "role",
        "dir",
        "container",
        "sasl",
        "isAuthenticated",
        "user",
        "isEncrypted",
        "sslProto",
        "sslCipher",
        "properties",
        "sslSsf",
        "tenant",
        "type",
        "ssl",
        "opened",
        "active",
        "adminStatus",
        "operStatus"
      ],
      results: [
        [
          "connection/127.0.0.1:60244",
          "1",
          "127.0.0.1:60244",
          "inter-router",
          "in",
          "B",
          "ANONYMOUS",
          true,
          "anonymous",
          false,
          null,
          null,
          {
            product: "qpid-dispatch-router",
            version: "1.9.0-SNAPSHOT",
            "qd.conn-id": 1
          },
          0,
          null,
          "org.apache.qpid.dispatch.connection",
          false,
          true,
          true,
          "enabled",
          "up"
        ],
        [
          "connection/127.0.0.1:53474",
          "2",
          "127.0.0.1:53474",
          "normal",
          "in",
          "87c75b00-3eae-4289-b2ef-7faae85682b3",
          "ANONYMOUS",
          true,
          "anonymous",
          false,
          null,
          null,
          {},
          0,
          null,
          "org.apache.qpid.dispatch.connection",
          false,
          true,
          true,
          "enabled",
          "up"
        ],
        [
          "connection/::1",
          "8",
          "::1",
          "normal",
          "in",
          "9fdbf671-8845-ac4c-9912-21cad048e1c2",
          null,
          false,
          "anonymous",
          false,
          null,
          null,
          {
            console_identifier: "Dispatch console"
          },
          0,
          null,
          "org.apache.qpid.dispatch.connection",
          false,
          true,
          true,
          "enabled",
          "up"
        ]
      ]
    },
    "router.address": {
      attributeNames: [
        "name",
        "identity",
        "type",
        "key",
        "distribution",
        "inProcess",
        "subscriberCount",
        "remoteCount",
        "containerCount",
        "remoteHostRouters",
        "deliveriesIngress",
        "deliveriesEgress",
        "deliveriesTransit",
        "deliveriesToContainer",
        "deliveriesFromContainer",
        "deliveriesEgressRouteContainer",
        "deliveriesIngressRouteContainer",
        "transitOutstanding",
        "trackedDeliveries",
        "priority",
        "deliveriesRedirectedToFallback"
      ],
      results: [
        [
          "Lqdhello",
          "Lqdhello",
          "org.apache.qpid.dispatch.router.address",
          "Lqdhello",
          "flood",
          1,
          1,
          0,
          0,
          [],
          0,
          0,
          0,
          2671,
          2673,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "Lqdrouter",
          "Lqdrouter",
          "org.apache.qpid.dispatch.router.address",
          "Lqdrouter",
          "flood",
          1,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          4,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "Lqdrouter.ma",
          "Lqdrouter.ma",
          "org.apache.qpid.dispatch.router.address",
          "Lqdrouter.ma",
          "multicast",
          1,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "Tqdrouter",
          "Tqdrouter",
          "org.apache.qpid.dispatch.router.address",
          "Tqdrouter",
          "flood",
          1,
          0,
          1,
          0,
          ["B"],
          0,
          0,
          91,
          90,
          92,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "Tqdrouter.ma",
          "Tqdrouter.ma",
          "org.apache.qpid.dispatch.router.address",
          "Tqdrouter.ma",
          "multicast",
          1,
          0,
          1,
          0,
          ["B"],
          0,
          0,
          0,
          1,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "M0$qd.edge_addr_tracking",
          "M0$qd.edge_addr_tracking",
          "org.apache.qpid.dispatch.router.address",
          "M0$qd.edge_addr_tracking",
          "balanced",
          0,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "M0$qd.addr_lookup",
          "M0$qd.addr_lookup",
          "org.apache.qpid.dispatch.router.address",
          "M0$qd.addr_lookup",
          "balanced",
          0,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "M0$management",
          "M0$management",
          "org.apache.qpid.dispatch.router.address",
          "M0$management",
          "closest",
          1,
          0,
          0,
          0,
          [],
          199,
          0,
          0,
          199,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "L$management",
          "L$management",
          "org.apache.qpid.dispatch.router.address",
          "L$management",
          "closest",
          1,
          0,
          0,
          0,
          [],
          2537,
          0,
          0,
          2537,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "L$_management_internal",
          "L$_management_internal",
          "org.apache.qpid.dispatch.router.address",
          "L$_management_internal",
          "closest",
          1,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          898,
          898,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "RB",
          "RB",
          "org.apache.qpid.dispatch.router.address",
          "RB",
          "closest",
          0,
          0,
          1,
          0,
          ["B"],
          2517,
          0,
          2521,
          0,
          4,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "M0toB",
          "M0toB",
          "org.apache.qpid.dispatch.router.address",
          "M0toB",
          "balanced",
          0,
          0,
          1,
          0,
          ["B"],
          26490,
          0,
          26490,
          0,
          0,
          0,
          0,
          [
            250,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0
          ],
          250,
          -1,
          0
        ],
        [
          "Ltemp.YcA7nMPUSTUXLvX",
          "Ltemp.YcA7nMPUSTUXLvX",
          "org.apache.qpid.dispatch.router.address",
          "Ltemp.YcA7nMPUSTUXLvX",
          "balanced",
          0,
          1,
          0,
          0,
          [],
          0,
          11,
          0,
          0,
          8,
          0,
          0,
          [
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0
          ],
          0,
          -1,
          0
        ]
      ]
    },
    "router.link": {
      attributeNames: [
        "name",
        "identity",
        "type",
        "linkName",
        "linkType",
        "linkDir",
        "owningAddr",
        "capacity",
        "peer",
        "undeliveredCount",
        "unsettledCount",
        "deliveryCount",
        "connectionId",
        "adminStatus",
        "operStatus",
        "presettledCount",
        "droppedPresettledCount",
        "acceptedCount",
        "rejectedCount",
        "releasedCount",
        "modifiedCount",
        "deliveriesDelayed1Sec",
        "deliveriesDelayed10Sec",
        "ingressHistogram",
        "priority",
        "settleRate"
      ],
      results: [
        [
          "qdlink.HlE3UASSFLV752W",
          "1",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.HlE3UASSFLV752W",
          "router-control",
          "out",
          "Lqdhello",
          250,
          null,
          0,
          0,
          25137,
          "1",
          "enabled",
          "up",
          25137,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.C6KVq3vkFQ32OOk",
          "2",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.C6KVq3vkFQ32OOk",
          "router-control",
          "in",
          null,
          250,
          null,
          0,
          0,
          25137,
          "1",
          "enabled",
          "up",
          25137,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          1
        ],
        [
          "qdlink.ptWU55qBgJu6vEP",
          "3",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.ptWU55qBgJu6vEP",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.mMWvv2Qkl7axiGL",
          "4",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.mMWvv2Qkl7axiGL",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.IWWZ6XNE_Mm+i7s",
          "5",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.IWWZ6XNE_Mm+i7s",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          1,
          0
        ],
        [
          "qdlink.pBCUdQxxhBB2CC8",
          "6",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.pBCUdQxxhBB2CC8",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.cH8isYfcxJBuCU6",
          "7",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.cH8isYfcxJBuCU6",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          2,
          0
        ],
        [
          "qdlink.DceyJ0JJVGInisj",
          "8",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.DceyJ0JJVGInisj",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.bFL8XkygAKoMIIK",
          "9",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.bFL8XkygAKoMIIK",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          3,
          0
        ],
        [
          "qdlink.RtgqZrOrSuwVZTL",
          "10",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.RtgqZrOrSuwVZTL",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.E0rBQ_++yb7FEMC",
          "11",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.E0rBQ_++yb7FEMC",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          250,
          258141,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          90,
          242220,
          null,
          4,
          0
        ],
        [
          "qdlink.8ql1AqDuJ9Mwopf",
          "12",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.8ql1AqDuJ9Mwopf",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          15559,
          "1",
          "enabled",
          "up",
          15559,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          1
        ],
        [
          "qdlink.HFFTij9L_ZjQzLJ",
          "13",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.HFFTij9L_ZjQzLJ",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          5,
          0
        ],
        [
          "qdlink.rSfNDFepjUfRdUd",
          "14",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.rSfNDFepjUfRdUd",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.co1Erzq3OfR3P2+",
          "15",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.co1Erzq3OfR3P2+",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          6,
          0
        ],
        [
          "qdlink.YErp_Dqo_ehs8tB",
          "16",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.YErp_Dqo_ehs8tB",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.oGY6hVxub6QU4Vj",
          "17",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.oGY6hVxub6QU4Vj",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          7,
          0
        ],
        [
          "qdlink.k91TFsV3LokqZ4C",
          "18",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.k91TFsV3LokqZ4C",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.o+uHBeFqSCVE8A+",
          "19",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.o+uHBeFqSCVE8A+",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          8,
          0
        ],
        [
          "qdlink.ZPNRS3549cd0HoR",
          "20",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.ZPNRS3549cd0HoR",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.5hC8iIL38YfWgSs",
          "21",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.5hC8iIL38YfWgSs",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          9,
          0
        ],
        [
          "qdlink.kdS8+8+uqrdxJ7I",
          "22",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.kdS8+8+uqrdxJ7I",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "87c75b00-3eae-4289-b2ef-7faae85682b3-toB",
          "23",
          "org.apache.qpid.dispatch.router.link",
          "87c75b00-3eae-4289-b2ef-7faae85682b3-toB",
          "endpoint",
          "in",
          "M0toB",
          250,
          null,
          0,
          250,
          242580,
          "2",
          "enabled",
          "up",
          0,
          0,
          242330,
          0,
          0,
          0,
          90,
          242220,
          null,
          0,
          8
        ],
        [
          "7f98817b-9849-474c-ae01-95abb185515f",
          "94",
          "org.apache.qpid.dispatch.router.link",
          "7f98817b-9849-474c-ae01-95abb185515f",
          "endpoint",
          "out",
          "Ltemp.kNLcXicad9jl7qj",
          250,
          null,
          0,
          0,
          50,
          "38",
          "enabled",
          "up",
          50,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          [
            14,
            9,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0
          ],
          0,
          3
        ],
        [
          "5e3e601e-1555-1446-864b-b8ab047e4da3",
          "95",
          "org.apache.qpid.dispatch.router.link",
          "5e3e601e-1555-1446-864b-b8ab047e4da3",
          "endpoint",
          "in",
          null,
          250,
          null,
          0,
          0,
          53,
          "38",
          "enabled",
          "up",
          0,
          0,
          53,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          4
        ]
      ]
    }
  },
  "amqp:/_topo/0/B/$management": {
    "router.node": {
      results: [
        ["B", 0],
        ["A", 1]
      ],
      attributeNames: ["id", "index"]
    },
    connection: {
      attributeNames: [
        "name",
        "identity",
        "host",
        "role",
        "dir",
        "container",
        "sasl",
        "isAuthenticated",
        "user",
        "isEncrypted",
        "sslProto",
        "sslCipher",
        "properties",
        "sslSsf",
        "tenant",
        "type",
        "ssl",
        "opened",
        "active",
        "adminStatus",
        "operStatus"
      ],
      results: [
        [
          "connection/0.0.0.0:2000",
          "1",
          "0.0.0.0:2000",
          "inter-router",
          "out",
          "A",
          "ANONYMOUS",
          true,
          null,
          false,
          null,
          null,
          {
            product: "qpid-dispatch-router",
            version: "1.9.0-SNAPSHOT",
            "qd.conn-id": 1
          },
          0,
          null,
          "org.apache.qpid.dispatch.connection",
          false,
          true,
          true,
          "enabled",
          "up"
        ],
        [
          "connection/127.0.0.1:34780",
          "2",
          "127.0.0.1:34780",
          "normal",
          "in",
          "af560918-3c35-4bf4-a9da-eef5a11ff7ec",
          "ANONYMOUS",
          true,
          "anonymous",
          false,
          null,
          null,
          {},
          0,
          null,
          "org.apache.qpid.dispatch.connection",
          false,
          true,
          true,
          "enabled",
          "up"
        ]
      ]
    },
    log: {
      results: [
        [
          "HTTP",
          null,
          null,
          null,
          null,
          "log/HTTP",
          "log/HTTP",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER_LS",
          null,
          null,
          null,
          null,
          "log/ROUTER_LS",
          "log/ROUTER_LS",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "DEFAULT",
          "info+",
          true,
          false,
          "stderr",
          "log/DEFAULT",
          "log/DEFAULT",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "PYTHON",
          null,
          null,
          null,
          null,
          "log/PYTHON",
          "log/PYTHON",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER_MA",
          null,
          null,
          null,
          null,
          "log/ROUTER_MA",
          "log/ROUTER_MA",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "CONN_MGR",
          null,
          null,
          null,
          null,
          "log/CONN_MGR",
          "log/CONN_MGR",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER_HELLO",
          null,
          null,
          null,
          null,
          "log/ROUTER_HELLO",
          "log/ROUTER_HELLO",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "SERVER",
          null,
          null,
          null,
          null,
          "log/SERVER",
          "log/SERVER",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "POLICY",
          null,
          null,
          null,
          null,
          "log/POLICY",
          "log/POLICY",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "CONTAINER",
          null,
          null,
          null,
          null,
          "log/CONTAINER",
          "log/CONTAINER",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "AGENT",
          null,
          null,
          null,
          null,
          "log/AGENT",
          "log/AGENT",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ERROR",
          null,
          null,
          null,
          null,
          "log/ERROR",
          "log/ERROR",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER_CORE",
          null,
          null,
          null,
          null,
          "log/ROUTER_CORE",
          "log/ROUTER_CORE",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "ROUTER",
          null,
          null,
          null,
          null,
          "log/ROUTER",
          "log/ROUTER",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "MESSAGE",
          null,
          null,
          null,
          null,
          "log/MESSAGE",
          "log/MESSAGE",
          "org.apache.qpid.dispatch.log"
        ],
        [
          "AUTHSERVICE",
          null,
          null,
          null,
          null,
          "log/AUTHSERVICE",
          "log/AUTHSERVICE",
          "org.apache.qpid.dispatch.log"
        ]
      ],
      attributeNames: [
        "module",
        "enable",
        "includeTimestamp",
        "includeSource",
        "outputFile",
        "name",
        "identity",
        "type"
      ]
    },
    logStats: {
      results: [
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "DEFAULT",
          "logStats/DEFAULT",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "ERROR",
          "logStats/ERROR",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "PYTHON",
          "logStats/PYTHON",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "MESSAGE",
          "logStats/MESSAGE",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "MAIN",
          "logStats/MAIN",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          1470,
          1,
          0,
          0,
          0,
          0,
          "AGENT",
          "logStats/AGENT",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          2,
          0,
          0,
          0,
          0,
          "POLICY",
          "logStats/POLICY",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "HTTP",
          "logStats/HTTP",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          191,
          0,
          4,
          0,
          0,
          0,
          0,
          "ROUTER_LS",
          "logStats/ROUTER_LS",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          1,
          0,
          0,
          0,
          0,
          0,
          0,
          "ROUTER_MA",
          "logStats/ROUTER_MA",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          2,
          0,
          0,
          0,
          0,
          "CONN_MGR",
          "logStats/CONN_MGR",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          5343,
          0,
          0,
          0,
          0,
          0,
          0,
          "ROUTER_HELLO",
          "logStats/ROUTER_HELLO",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          3,
          2,
          0,
          0,
          0,
          "SERVER",
          "logStats/SERVER",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "CONTAINER",
          "logStats/CONTAINER",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "ROUTER_CORE",
          "logStats/ROUTER_CORE",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          6,
          0,
          20,
          0,
          0,
          0,
          0,
          "ROUTER",
          "logStats/ROUTER",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "AUTHSERVICE",
          "logStats/AUTHSERVICE",
          "org.apache.qpid.dispatch.logStats"
        ],
        [
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          "DISPLAYNAME",
          "logStats/DISPLAYNAME",
          "org.apache.qpid.dispatch.logStats"
        ]
      ],
      attributeNames: [
        "traceCount",
        "debugCount",
        "infoCount",
        "noticeCount",
        "warningCount",
        "errorCount",
        "criticalCount",
        "name",
        "identity",
        "type"
      ]
    },
    router: {
      attributeNames: [
        "name",
        "identity",
        "id",
        "type",
        "mode",
        "area",
        "version",
        "addrCount",
        "linkCount",
        "nodeCount",
        "linkRouteCount",
        "autoLinkCount",
        "connectionCount",
        "presettledDeliveries",
        "droppedPresettledDeliveries",
        "acceptedDeliveries",
        "rejectedDeliveries",
        "releasedDeliveries",
        "modifiedDeliveries",
        "deliveriesDelayed1Sec",
        "deliveriesDelayed10Sec",
        "deliveriesIngress",
        "deliveriesEgress",
        "deliveriesTransit",
        "deliveriesIngressRouteContainer",
        "deliveriesEgressRouteContainer",
        "deliveriesRedirectedToFallback"
      ],
      results: [
        [
          "B",
          "1",
          "B",
          "org.apache.qpid.dispatch.router",
          "interior",
          "0",
          "1.9.0-SNAPSHOT",
          12,
          23,
          1,
          0,
          0,
          2,
          0,
          0,
          28761,
          0,
          0,
          0,
          90,
          26130,
          0,
          26490,
          2519,
          0,
          0,
          0
        ]
      ]
    },
    "router.address": {
      attributeNames: [
        "name",
        "identity",
        "type",
        "key",
        "distribution",
        "inProcess",
        "subscriberCount",
        "remoteCount",
        "containerCount",
        "remoteHostRouters",
        "deliveriesIngress",
        "deliveriesEgress",
        "deliveriesTransit",
        "deliveriesToContainer",
        "deliveriesFromContainer",
        "deliveriesEgressRouteContainer",
        "deliveriesIngressRouteContainer",
        "transitOutstanding",
        "trackedDeliveries",
        "priority",
        "deliveriesRedirectedToFallback"
      ],
      results: [
        [
          "Lqdhello",
          "Lqdhello",
          "org.apache.qpid.dispatch.router.address",
          "Lqdhello",
          "flood",
          1,
          1,
          0,
          0,
          [],
          0,
          0,
          0,
          2672,
          2671,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "Lqdrouter",
          "Lqdrouter",
          "org.apache.qpid.dispatch.router.address",
          "Lqdrouter",
          "flood",
          1,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          4,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "Lqdrouter.ma",
          "Lqdrouter.ma",
          "org.apache.qpid.dispatch.router.address",
          "Lqdrouter.ma",
          "multicast",
          1,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "Tqdrouter",
          "Tqdrouter",
          "org.apache.qpid.dispatch.router.address",
          "Tqdrouter",
          "flood",
          1,
          0,
          1,
          0,
          ["A"],
          0,
          0,
          90,
          91,
          91,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "Tqdrouter.ma",
          "Tqdrouter.ma",
          "org.apache.qpid.dispatch.router.address",
          "Tqdrouter.ma",
          "multicast",
          1,
          0,
          1,
          0,
          ["A"],
          0,
          0,
          1,
          0,
          1,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "M0$qd.edge_addr_tracking",
          "M0$qd.edge_addr_tracking",
          "org.apache.qpid.dispatch.router.address",
          "M0$qd.edge_addr_tracking",
          "balanced",
          0,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "M0$qd.addr_lookup",
          "M0$qd.addr_lookup",
          "org.apache.qpid.dispatch.router.address",
          "M0$qd.addr_lookup",
          "balanced",
          0,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "M0$management",
          "M0$management",
          "org.apache.qpid.dispatch.router.address",
          "M0$management",
          "closest",
          1,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "L$management",
          "L$management",
          "org.apache.qpid.dispatch.router.address",
          "L$management",
          "closest",
          1,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          2523,
          0,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "L$_management_internal",
          "L$_management_internal",
          "org.apache.qpid.dispatch.router.address",
          "L$_management_internal",
          "closest",
          1,
          0,
          0,
          0,
          [],
          0,
          0,
          0,
          696,
          696,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "RA",
          "RA",
          "org.apache.qpid.dispatch.router.address",
          "RA",
          "closest",
          0,
          0,
          1,
          0,
          ["A"],
          0,
          0,
          2525,
          0,
          2525,
          0,
          0,
          null,
          0,
          -1,
          0
        ],
        [
          "M0toB",
          "M0toB",
          "org.apache.qpid.dispatch.router.address",
          "M0toB",
          "balanced",
          0,
          1,
          0,
          0,
          [],
          0,
          26490,
          0,
          0,
          0,
          0,
          0,
          [
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0
          ],
          0,
          -1,
          0
        ]
      ]
    },
    "router.link": {
      attributeNames: [
        "name",
        "identity",
        "type",
        "linkName",
        "linkType",
        "linkDir",
        "owningAddr",
        "capacity",
        "peer",
        "undeliveredCount",
        "unsettledCount",
        "deliveryCount",
        "connectionId",
        "adminStatus",
        "operStatus",
        "presettledCount",
        "droppedPresettledCount",
        "acceptedCount",
        "rejectedCount",
        "releasedCount",
        "modifiedCount",
        "deliveriesDelayed1Sec",
        "deliveriesDelayed10Sec",
        "ingressHistogram",
        "priority",
        "settleRate"
      ],
      results: [
        [
          "qdlink.HlE3UASSFLV752W",
          "1",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.HlE3UASSFLV752W",
          "router-control",
          "in",
          null,
          250,
          null,
          0,
          0,
          25137,
          "1",
          "enabled",
          "up",
          25137,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.C6KVq3vkFQ32OOk",
          "2",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.C6KVq3vkFQ32OOk",
          "router-control",
          "out",
          "Lqdhello",
          250,
          null,
          0,
          0,
          25137,
          "1",
          "enabled",
          "up",
          25137,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          1
        ],
        [
          "qdlink.ptWU55qBgJu6vEP",
          "3",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.ptWU55qBgJu6vEP",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.mMWvv2Qkl7axiGL",
          "4",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.mMWvv2Qkl7axiGL",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.IWWZ6XNE_Mm+i7s",
          "5",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.IWWZ6XNE_Mm+i7s",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.pBCUdQxxhBB2CC8",
          "6",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.pBCUdQxxhBB2CC8",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          1,
          0
        ],
        [
          "qdlink.cH8isYfcxJBuCU6",
          "7",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.cH8isYfcxJBuCU6",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.DceyJ0JJVGInisj",
          "8",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.DceyJ0JJVGInisj",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          2,
          0
        ],
        [
          "qdlink.bFL8XkygAKoMIIK",
          "9",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.bFL8XkygAKoMIIK",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.RtgqZrOrSuwVZTL",
          "10",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.RtgqZrOrSuwVZTL",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          3,
          0
        ],
        [
          "qdlink.E0rBQ_++yb7FEMC",
          "11",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.E0rBQ_++yb7FEMC",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          250,
          258141,
          "1",
          "enabled",
          "up",
          0,
          0,
          257891,
          0,
          0,
          0,
          90,
          242220,
          null,
          0,
          10
        ],
        [
          "qdlink.8ql1AqDuJ9Mwopf",
          "12",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.8ql1AqDuJ9Mwopf",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          15560,
          "1",
          "enabled",
          "up",
          15560,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          4,
          1
        ],
        [
          "qdlink.HFFTij9L_ZjQzLJ",
          "13",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.HFFTij9L_ZjQzLJ",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.rSfNDFepjUfRdUd",
          "14",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.rSfNDFepjUfRdUd",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          5,
          0
        ],
        [
          "qdlink.co1Erzq3OfR3P2+",
          "15",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.co1Erzq3OfR3P2+",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.YErp_Dqo_ehs8tB",
          "16",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.YErp_Dqo_ehs8tB",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          6,
          0
        ],
        [
          "qdlink.oGY6hVxub6QU4Vj",
          "17",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.oGY6hVxub6QU4Vj",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.k91TFsV3LokqZ4C",
          "18",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.k91TFsV3LokqZ4C",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          7,
          0
        ],
        [
          "qdlink.o+uHBeFqSCVE8A+",
          "19",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.o+uHBeFqSCVE8A+",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.ZPNRS3549cd0HoR",
          "20",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.ZPNRS3549cd0HoR",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          8,
          0
        ],
        [
          "qdlink.5hC8iIL38YfWgSs",
          "21",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.5hC8iIL38YfWgSs",
          "inter-router",
          "in",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          0,
          0
        ],
        [
          "qdlink.kdS8+8+uqrdxJ7I",
          "22",
          "org.apache.qpid.dispatch.router.link",
          "qdlink.kdS8+8+uqrdxJ7I",
          "inter-router",
          "out",
          null,
          250,
          null,
          0,
          0,
          0,
          "1",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          0,
          null,
          9,
          0
        ],
        [
          "af560918-3c35-4bf4-a9da-eef5a11ff7ec-toB",
          "23",
          "org.apache.qpid.dispatch.router.link",
          "af560918-3c35-4bf4-a9da-eef5a11ff7ec-toB",
          "endpoint",
          "out",
          "M0toB",
          250,
          null,
          250,
          0,
          242330,
          "2",
          "enabled",
          "up",
          0,
          0,
          0,
          0,
          0,
          0,
          90,
          242220,
          [
            0,
            242330,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0
          ],
          0,
          0
        ]
      ]
    }
  }
};
