/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.function.Consumer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.websocket.server.ServerWebSocketContainer;

public class WebSocketUpgradeHandler
extends Handler.Wrapper {
    private final ServerWebSocketContainer _container;
    private final Consumer<ServerWebSocketContainer> _configurator;

    public static WebSocketUpgradeHandler from(Server server, ContextHandler context) {
        return WebSocketUpgradeHandler.from(server, context, null);
    }

    public static WebSocketUpgradeHandler from(Server server, ContextHandler context, Consumer<ServerWebSocketContainer> configurator) {
        ServerWebSocketContainer container = ServerWebSocketContainer.ensure(server, context);
        return new WebSocketUpgradeHandler(container, configurator);
    }

    public static WebSocketUpgradeHandler from(Server server) {
        return WebSocketUpgradeHandler.from(server, (ServerWebSocketContainer container) -> {});
    }

    public static WebSocketUpgradeHandler from(Server server, Consumer<ServerWebSocketContainer> configurator) {
        return WebSocketUpgradeHandler.from(server, null, configurator);
    }

    public WebSocketUpgradeHandler(ServerWebSocketContainer container) {
        this(container, null);
    }

    public WebSocketUpgradeHandler(ServerWebSocketContainer container, Consumer<ServerWebSocketContainer> configurator) {
        this._container = container;
        this._configurator = configurator;
        this.installBean((Object)container);
    }

    @Deprecated
    public WebSocketUpgradeHandler configure(Consumer<ServerWebSocketContainer> configurator) {
        configurator.accept(this._container);
        return this;
    }

    public ServerWebSocketContainer getServerWebSocketContainer() {
        return this._container;
    }

    protected void doStart() throws Exception {
        if (this._configurator != null) {
            this._configurator.accept(this._container);
        }
        super.doStart();
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (this.handle(this._container, request, response, callback)) {
            return true;
        }
        return super.handle(request, response, callback);
    }

    protected boolean handle(ServerWebSocketContainer container, Request request, Response response, Callback callback) {
        try {
            return container.handle(request, response, callback);
        }
        catch (Throwable x) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (Throwable)x);
            return true;
        }
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.combine((Invocable.InvocationType)super.getInvocationType(), (Invocable.InvocationType)this._container.getInvocationType());
    }
}

