/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.RangeSet;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;

public final class SessionCommandFragment
extends Struct {
    public static final int TYPE = -2;
    private int commandId;
    private RangeSet byteRanges;

    @Override
    public final int getStructType() {
        return -2;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 0;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public SessionCommandFragment() {
    }

    public SessionCommandFragment(int commandId, RangeSet byteRanges) {
        this.setCommandId(commandId);
        if (byteRanges != null) {
            this.setByteRanges(byteRanges);
        }
    }

    public final int getCommandId() {
        return this.commandId;
    }

    public final SessionCommandFragment setCommandId(int value) {
        this.commandId = value;
        this.setDirty(true);
        return this;
    }

    public final SessionCommandFragment commandId(int value) {
        return this.setCommandId(value);
    }

    public final RangeSet getByteRanges() {
        return this.byteRanges;
    }

    public final SessionCommandFragment setByteRanges(RangeSet value) {
        this.byteRanges = value;
        this.setDirty(true);
        return this;
    }

    public final SessionCommandFragment byteRanges(RangeSet value) {
        return this.setByteRanges(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeSequenceNo(this.commandId);
        enc.writeByteRanges(this.byteRanges);
    }

    @Override
    public void read(Decoder dec) {
        this.commandId = dec.readSequenceNo();
        this.byteRanges = dec.readByteRanges();
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("commandId", this.getCommandId());
        result.put("byteRanges", this.getByteRanges());
        return result;
    }

    @Override
    public int getEncodedLength() {
        throw new UnsupportedOperationException();
    }
}

