/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.util.List;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionClose;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionCloseCode;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionCloseOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionHeartbeat;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionOpen;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionOpenOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionRedirect;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionSecure;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionSecureOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionStart;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionStartOk;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionTune;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionTuneOk;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.Option;

public abstract class ConnectionInvoker {
    final void connectionStart(Map<String, Object> serverProperties, List<Object> mechanisms, List<Object> locales, Option ... _options) {
        this.invoke(new ConnectionStart(serverProperties, mechanisms, locales, _options));
    }

    final void connectionStartOk(Map<String, Object> clientProperties, String mechanism, byte[] response, String locale, Option ... _options) {
        this.invoke(new ConnectionStartOk(clientProperties, mechanism, response, locale, _options));
    }

    final void connectionSecure(byte[] challenge, Option ... _options) {
        this.invoke(new ConnectionSecure(challenge, _options));
    }

    final void connectionSecureOk(byte[] response, Option ... _options) {
        this.invoke(new ConnectionSecureOk(response, _options));
    }

    final void connectionTune(int channelMax, int maxFrameSize, int heartbeatMin, int heartbeatMax, Option ... _options) {
        this.invoke(new ConnectionTune(channelMax, maxFrameSize, heartbeatMin, heartbeatMax, _options));
    }

    final void connectionTuneOk(int channelMax, int maxFrameSize, int heartbeat, Option ... _options) {
        this.invoke(new ConnectionTuneOk(channelMax, maxFrameSize, heartbeat, _options));
    }

    final void connectionOpen(String virtualHost, List<Object> capabilities, Option ... _options) {
        this.invoke(new ConnectionOpen(virtualHost, capabilities, _options));
    }

    final void connectionOpenOk(List<Object> knownHosts, Option ... _options) {
        this.invoke(new ConnectionOpenOk(knownHosts, _options));
    }

    final void connectionRedirect(String host, List<Object> knownHosts, Option ... _options) {
        this.invoke(new ConnectionRedirect(host, knownHosts, _options));
    }

    final void connectionHeartbeat(Option ... _options) {
        this.invoke(new ConnectionHeartbeat(_options));
    }

    final void connectionClose(ConnectionCloseCode replyCode, String replyText, Option ... _options) {
        this.invoke(new ConnectionClose(replyCode, replyText, _options));
    }

    final void connectionCloseOk(Option ... _options) {
        this.invoke(new ConnectionCloseOk(_options));
    }

    protected abstract void invoke(Method var1);
}

