/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.je.DatabaseEntry;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.store.MessageMetaDataTypeRegistry;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreException;

public class MessageMetaDataBinding
implements EntryBinding<StorableMessageMetaData> {
    private static final MessageMetaDataBinding INSTANCE = new MessageMetaDataBinding();

    public static MessageMetaDataBinding getInstance() {
        return INSTANCE;
    }

    private MessageMetaDataBinding() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public StorableMessageMetaData entryToObject(DatabaseEntry entry) {
        try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(entry.getData(), entry.getOffset(), entry.getSize()));){
            StorableMessageMetaData storableMessageMetaData;
            block13: {
                int bodySize = stream.readInt() ^ Integer.MIN_VALUE;
                int metaDataType = stream.readByte() & 0xFF;
                MessageMetaDataType type = MessageMetaDataTypeRegistry.fromOrdinal((int)metaDataType);
                QpidByteBuffer buf = QpidByteBuffer.asQpidByteBuffer((InputStream)stream);
                try {
                    storableMessageMetaData = type.createMetaData(buf);
                    if (buf == null) break block13;
                }
                catch (Throwable throwable) {
                    if (buf != null) {
                        try {
                            buf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                buf.close();
            }
            return storableMessageMetaData;
        }
        catch (IOException | RuntimeException e) {
            throw new StoreException(String.format("Unable to convert entry %s to metadata", entry));
        }
    }

    public void objectToEntry(StorableMessageMetaData metaData, DatabaseEntry entry) {
        int bodySize = 1 + metaData.getStorableSize();
        byte[] underlying = new byte[4 + bodySize];
        underlying[4] = (byte)metaData.getType().ordinal();
        try (QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])underlying);){
            buf.putInt(bodySize ^ Integer.MIN_VALUE);
            buf.position(5);
            try (QpidByteBuffer bufSlice = buf.slice();){
                metaData.writeToBuffer(bufSlice);
            }
        }
        entry.setData(underlying);
    }
}

