/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.query;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.filter.ArithmeticExpression;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.ComparisonExpression;
import org.apache.qpid.server.filter.ConstantExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.LogicExpression;
import org.apache.qpid.server.filter.NamedExpression;
import org.apache.qpid.server.filter.OrderByExpression;
import org.apache.qpid.server.filter.UnaryExpression;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectExpression;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectExpressionFactory;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectFilterParserConstants;
import org.apache.qpid.server.management.plugin.servlet.query.ConfiguredObjectFilterParserTokenManager;
import org.apache.qpid.server.management.plugin.servlet.query.ParseException;
import org.apache.qpid.server.management.plugin.servlet.query.SimpleCharStream;
import org.apache.qpid.server.management.plugin.servlet.query.Token;
import org.apache.qpid.server.model.ConfiguredObject;

public class ConfiguredObjectFilterParser<E extends ConfiguredObject<?>>
implements ConfiguredObjectFilterParserConstants {
    private ConfiguredObjectExpressionFactory _factory;
    public ConfiguredObjectFilterParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private static final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private boolean trace_enabled;

    public ConfiguredObjectFilterParser() {
        this(new StringReader(""));
    }

    public void setConfiguredObjectExpressionFactory(ConfiguredObjectExpressionFactory factory) {
        this._factory = factory;
    }

    public BooleanExpression<E> parseWhere(String sql) throws ParseException {
        this.ReInit(new StringReader(sql));
        return this.filter();
    }

    public List<Map<String, Expression>> parseSelect(String sql) throws ParseException {
        this.ReInit(new StringReader(sql));
        return this.selectClause();
    }

    public List<OrderByExpression<E>> parseOrderBy(String sql) throws ParseException {
        this.ReInit(new StringReader(sql));
        return this.orderByClause();
    }

    private BooleanExpression<E> asBooleanExpression(Expression<E> value) throws ParseException {
        if (value instanceof BooleanExpression) {
            return (BooleanExpression)value;
        }
        if (value instanceof ConfiguredObjectExpression) {
            return UnaryExpression.createBooleanCast(value);
        }
        throw new ParseException("Expression will not result in a boolean value: " + String.valueOf(value));
    }

    public final BooleanExpression<E> filter() throws ParseException {
        Expression<E> left = null;
        left = this.orExpression();
        this.jj_consume_token(0);
        return this.asBooleanExpression(left);
    }

    public final Expression<E> orExpression() throws ParseException {
        BooleanExpression left = this.andExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(10);
            Expression<E> right = this.andExpression();
            left = LogicExpression.createOR(this.asBooleanExpression((Expression<E>)left), this.asBooleanExpression(right));
        }
        return left;
    }

    public final Expression<E> andExpression() throws ParseException {
        BooleanExpression left = this.equalityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(9);
            Expression<E> right = this.equalityExpression();
            left = LogicExpression.createAND(this.asBooleanExpression((Expression<E>)left), this.asBooleanExpression(right));
        }
        return left;
    }

    public final Expression<E> equalityExpression() throws ParseException {
        BooleanExpression left;
        block12: {
            left = this.comparisonExpression();
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: 
                    case 31: 
                    case 32: {
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 31: {
                        this.jj_consume_token(31);
                        Expression<E> right = this.comparisonExpression();
                        left = ComparisonExpression.createEqual(left, right);
                        continue block10;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        Expression<E> right = this.comparisonExpression();
                        left = ComparisonExpression.createNotEqual(left, right);
                        continue block10;
                    }
                }
                if (this.jj_2_1(2)) {
                    this.jj_consume_token(15);
                    this.jj_consume_token(18);
                    left = ComparisonExpression.createIsNull((Expression)left);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        this.jj_consume_token(8);
                        this.jj_consume_token(18);
                        left = ComparisonExpression.createIsNotNull((Expression)left);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    public final Expression<E> comparisonExpression() throws ParseException {
        BooleanExpression left;
        block33: {
            left = this.addExpression();
            block28: while (true) {
                ArrayList<Expression<E>> list;
                Expression<E> high;
                Expression<E> low;
                String t;
                String u;
                Expression<E> right;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: {
                        break;
                    }
                    default: {
                        break block33;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 33: {
                        this.jj_consume_token(33);
                        right = this.addExpression();
                        left = ComparisonExpression.createGreaterThan(left, right);
                        continue block28;
                    }
                    case 34: {
                        this.jj_consume_token(34);
                        right = this.addExpression();
                        left = ComparisonExpression.createGreaterThanEqual(left, right);
                        continue block28;
                    }
                    case 35: {
                        this.jj_consume_token(35);
                        right = this.addExpression();
                        left = ComparisonExpression.createLessThan(left, right);
                        continue block28;
                    }
                    case 36: {
                        this.jj_consume_token(36);
                        right = this.addExpression();
                        left = ComparisonExpression.createLessThanEqual(left, right);
                        continue block28;
                    }
                    case 12: {
                        u = null;
                        this.jj_consume_token(12);
                        t = this.stringLiteral();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 13: {
                                this.jj_consume_token(13);
                                u = this.stringLiteral();
                                break;
                            }
                        }
                        left = ComparisonExpression.createLike((Expression)left, (String)t, u);
                        continue block28;
                    }
                }
                if (this.jj_2_2(2)) {
                    u = null;
                    this.jj_consume_token(8);
                    this.jj_consume_token(12);
                    t = this.stringLiteral();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 13: {
                            this.jj_consume_token(13);
                            u = this.stringLiteral();
                            break;
                        }
                    }
                    left = ComparisonExpression.createNotLike((Expression)left, (String)t, (String)u);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        low = this.addExpression();
                        this.jj_consume_token(9);
                        high = this.addExpression();
                        left = ComparisonExpression.createBetween((Expression)left, low, high);
                        continue block28;
                    }
                }
                if (this.jj_2_3(2)) {
                    this.jj_consume_token(8);
                    this.jj_consume_token(11);
                    low = this.addExpression();
                    this.jj_consume_token(9);
                    high = this.addExpression();
                    left = ComparisonExpression.createNotBetween((Expression)left, low, high);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        this.jj_consume_token(37);
                        right = this.primaryExpr();
                        list = new ArrayList<Expression<E>>();
                        list.add(right);
                        block29: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 38: {
                                    break;
                                }
                                default: {
                                    break block29;
                                }
                            }
                            this.jj_consume_token(38);
                            right = this.primaryExpr();
                            list.add(right);
                        }
                        this.jj_consume_token(39);
                        left = ComparisonExpression.createInFilter((Expression)left, list, (boolean)true);
                        continue block28;
                    }
                }
                if (!this.jj_2_4(2)) break;
                this.jj_consume_token(8);
                this.jj_consume_token(14);
                this.jj_consume_token(37);
                right = this.primaryExpr();
                list = new ArrayList();
                list.add(right);
                block30: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: {
                            break;
                        }
                        default: {
                            break block30;
                        }
                    }
                    this.jj_consume_token(38);
                    right = this.primaryExpr();
                    list.add(right);
                }
                this.jj_consume_token(39);
                left = ComparisonExpression.createNotInFilter((Expression)left, list, (boolean)true);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    public final Expression<E> addExpression() throws ParseException {
        Expression left = this.multExpr();
        block4: while (this.jj_2_5(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: {
                    this.jj_consume_token(40);
                    Expression<E> right = this.multExpr();
                    left = ArithmeticExpression.createPlus(left, right);
                    continue block4;
                }
                case 41: {
                    this.jj_consume_token(41);
                    Expression<E> right = this.multExpr();
                    left = ArithmeticExpression.createMinus(left, right);
                    continue block4;
                }
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    public final Expression<E> multExpr() throws ParseException {
        Expression left;
        block9: {
            left = this.unaryExpr();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 42: 
                    case 43: 
                    case 44: {
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 42: {
                        this.jj_consume_token(42);
                        Expression<E> right = this.unaryExpr();
                        left = ArithmeticExpression.createMultiply(left, right);
                        continue block8;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        Expression<E> right = this.unaryExpr();
                        left = ArithmeticExpression.createDivide(left, right);
                        continue block8;
                    }
                    case 44: {
                        this.jj_consume_token(44);
                        Expression<E> right = this.unaryExpr();
                        left = ArithmeticExpression.createMod(left, right);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    public final Expression<E> unaryExpr() throws ParseException {
        Object s = null;
        Expression left = null;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(40);
            left = this.unaryExpr();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    this.jj_consume_token(41);
                    left = this.unaryExpr();
                    left = UnaryExpression.createNegate(left);
                    break;
                }
                case 8: {
                    this.jj_consume_token(8);
                    left = this.unaryExpr();
                    left = UnaryExpression.createNOT(this.asBooleanExpression(left));
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 37: {
                    left = this.primaryExpr();
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return left;
    }

    public final Expression<E> primaryExpr() throws ParseException {
        Expression<E> left = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: {
                left = this.functionExpression();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                left = this.literal();
                break;
            }
            case 29: 
            case 30: {
                left = this.variable();
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                left = this.orExpression();
                this.jj_consume_token(39);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return left;
    }

    public final ConstantExpression<E> literal() throws ParseException {
        ConstantExpression.BooleanConstantExpression left = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 27: {
                String s = this.stringLiteral();
                left = new ConstantExpression((Object)s);
                break;
            }
            case 22: {
                Token t = this.jj_consume_token(22);
                left = ConstantExpression.createFromDecimal((String)t.image);
                break;
            }
            case 23: {
                Token t = this.jj_consume_token(23);
                left = ConstantExpression.createFromHex((String)t.image);
                break;
            }
            case 24: {
                Token t = this.jj_consume_token(24);
                left = ConstantExpression.createFromOctal((String)t.image);
                break;
            }
            case 25: {
                Token t = this.jj_consume_token(25);
                left = ConstantExpression.createFloat((String)t.image);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                left = ConstantExpression.TRUE;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                left = ConstantExpression.FALSE;
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                left = ConstantExpression.NULL;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return left;
    }

    public final String stringLiteral() throws ParseException {
        StringBuffer rc = new StringBuffer();
        boolean first = true;
        Token t = this.jj_consume_token(27);
        String image = t.image;
        for (int i = 1; i < image.length() - 1; ++i) {
            char c = image.charAt(i);
            if (c == '\'') {
                ++i;
            }
            rc.append(c);
        }
        return rc.toString();
    }

    public final ConfiguredObjectExpression variable() throws ParseException {
        if (this.jj_2_7(2)) {
            String s = this.identifier();
            this.jj_consume_token(45);
            ConfiguredObjectExpression right = this.variable();
            return this._factory.createConfiguredObjectExpression(s, right);
        }
        if (this.jj_2_8(2)) {
            String s = this.identifier();
            this.jj_consume_token(46);
            Token t = this.jj_consume_token(22);
            this.jj_consume_token(47);
            return this._factory.createConfiguredObjectExpression(s, Integer.valueOf(t.image));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: 
            case 30: {
                String s = this.identifier();
                return this._factory.createConfiguredObjectExpression(s);
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expression<E> functionExpression() throws ParseException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        Token t = this.jj_consume_token(28);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 37: 
            case 40: 
            case 41: {
                Expression<E> expr = this.addExpression();
                args.add(expr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: {
                            break;
                        }
                        default: {
                            break block0;
                        }
                    }
                    this.jj_consume_token(38);
                    expr = this.addExpression();
                    args.add(expr);
                }
            }
        }
        this.jj_consume_token(39);
        return this._factory.createFunctionExpression(t.image.substring(0, t.image.length() - 1), args);
    }

    public final String identifier() throws ParseException {
        StringBuffer rc = new StringBuffer();
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29 -> {
                Token t = this.jj_consume_token(29);
                yield t.image;
            }
            case 30 -> {
                Token t = this.jj_consume_token(30);
                String image = t.image;
                for (int i = 1; i < image.length() - 1; ++i) {
                    char c = image.charAt(i);
                    if (c == '\"') {
                        ++i;
                    }
                    rc.append(c);
                }
                yield rc.toString();
            }
            default -> {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final List<Map<String, Expression>> selectClause() throws ParseException {
        ArrayList<Map<String, Expression>> returnVal = new ArrayList<Map<String, Expression>>();
        Map<String, Expression> element = this.selectClauseElement();
        returnVal.add(element);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(38);
            element = this.selectClauseElement();
            returnVal.add(element);
        }
        this.jj_consume_token(0);
        return returnVal;
    }

    public final Map<String, Expression> selectClauseElement() throws ParseException {
        String name = null;
        Expression<E> expr = this.addExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                name = this.identifier();
                break;
            }
        }
        if (name == null) {
            name = expr instanceof NamedExpression ? ((NamedExpression)expr).getName() : "";
        }
        return Collections.singletonMap(name, expr);
    }

    public final List<OrderByExpression<E>> orderByClause() throws ParseException {
        ArrayList<OrderByExpression<OrderByExpression<E>>> returnVal = new ArrayList<OrderByExpression<OrderByExpression<E>>>();
        OrderByExpression<E> element = this.orderByClauseElement();
        returnVal.add(element);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(38);
            element = this.orderByClauseElement();
            returnVal.add(element);
        }
        this.jj_consume_token(0);
        return returnVal;
    }

    public final OrderByExpression<E> orderByClauseElement() throws ParseException {
        OrderByExpression.Order order = OrderByExpression.Order.ASC;
        Expression<E> expr = this.addExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 21: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        break block0;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        order = OrderByExpression.Order.DESC;
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new OrderByExpression(expr, order);
    }

    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_1();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_2();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_3();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_4();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_5();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_6();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_7();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_8();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_3R_comparisonExpression_344_35_67() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_stringLiteral_600_5_48();
    }

    private boolean jj_3R_literal_560_9_39() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_multExpr_462_9_24() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_unaryExpr_480_9_13();
    }

    private boolean jj_3R_functionExpression_656_5_30() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_functionExpression_657_30_34()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_equalityExpression_274_5_49() {
        Token xsp;
        if (this.jj_3R_comparisonExpression_316_5_52()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_equalityExpression_278_13_53());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_stringLiteral_600_5_48()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_comparisonExpression_353_60_68()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_340_33_64() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_stringLiteral_600_5_48()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_comparisonExpression_344_35_67()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_literal_553_9_38() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_multExpr_457_9_23() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_3R_unaryExpr_480_9_13();
    }

    private boolean jj_3R_multExpr_452_9_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_multExpr_452_9_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_multExpr_457_9_23()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_multExpr_462_9_24()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_multExpr_452_9_22() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        return this.jj_3R_unaryExpr_480_9_13();
    }

    private boolean jj_3R_andExpression_257_13_50() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_equalityExpression_274_5_49();
    }

    private boolean jj_3R_literal_546_9_37() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_multExpr_450_5_12() {
        Token xsp;
        if (this.jj_3R_unaryExpr_480_9_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_multExpr_452_9_15());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_variable_639_5_43() {
        return this.jj_3R_identifier_671_5_14();
    }

    private boolean jj_3R_literal_539_9_36() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_addExpression_432_17_55() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_multExpr_450_5_12();
    }

    private boolean jj_3R_andExpression_254_5_44() {
        Token xsp;
        if (this.jj_3R_equalityExpression_274_5_49()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_andExpression_257_13_50());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(41)) {
                return true;
            }
        }
        return this.jj_3R_multExpr_450_5_12();
    }

    private boolean jj_3R_comparisonExpression_335_17_63() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_3R_addExpression_423_5_46();
    }

    private boolean jj_3R_functionExpression_657_75_47() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_addExpression_423_5_46();
    }

    private boolean jj_3R_literal_532_9_35() {
        return this.jj_3R_stringLiteral_600_5_48();
    }

    private boolean jj_3_8() {
        if (this.jj_3R_identifier_671_5_14()) {
            return true;
        }
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_addExpression_427_17_54() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_multExpr_450_5_12();
    }

    private boolean jj_3R_comparisonExpression_330_17_62() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        return this.jj_3R_addExpression_423_5_46();
    }

    private boolean jj_3R_literal_531_5_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_literal_532_9_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_literal_539_9_36()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_literal_546_9_37()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_literal_553_9_38()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_literal_560_9_39()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_literal_567_9_40()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_literal_574_9_41()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_literal_581_9_42()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_398_41_70() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_primaryExpr_507_5_25();
    }

    private boolean jj_3R_addExpression_425_13_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_addExpression_427_17_54()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_addExpression_432_17_55()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_orExpression_235_13_45() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_andExpression_254_5_44();
    }

    private boolean jj_3_7() {
        if (this.jj_3R_identifier_671_5_14()) {
            return true;
        }
        if (this.jj_scan_token(45)) {
            return true;
        }
        return this.jj_3R_variable_623_5_32();
    }

    private boolean jj_3R_variable_623_5_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_8()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_variable_639_5_43()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_325_17_61() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_addExpression_423_5_46();
    }

    private boolean jj_3R_comparisonExpression_320_17_60() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_addExpression_423_5_46();
    }

    private boolean jj_3R_comparisonExpression_320_17_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_comparisonExpression_320_17_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_comparisonExpression_325_17_61()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_comparisonExpression_330_17_62()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_comparisonExpression_335_17_63()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_comparisonExpression_340_33_64()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_2()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_comparisonExpression_358_25_65()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_3()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_comparisonExpression_369_33_66()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_4()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_addExpression_423_5_46() {
        Token xsp;
        if (this.jj_3R_multExpr_450_5_12()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_addExpression_425_13_51());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_primaryExpr_514_9_29() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_3R_orExpression_232_5_33()) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_orExpression_232_5_33() {
        Token xsp;
        if (this.jj_3R_andExpression_254_5_44()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_orExpression_235_13_45());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_primaryExpr_512_9_28() {
        return this.jj_3R_variable_623_5_32();
    }

    private boolean jj_3R_primaryExpr_510_9_27() {
        return this.jj_3R_literal_531_5_31();
    }

    private boolean jj_3R_primaryExpr_508_9_26() {
        return this.jj_3R_functionExpression_656_5_30();
    }

    private boolean jj_3R_comparisonExpression_377_41_69() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_primaryExpr_507_5_25();
    }

    private boolean jj_3R_primaryExpr_507_5_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_primaryExpr_508_9_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_primaryExpr_510_9_27()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_primaryExpr_512_9_28()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_primaryExpr_514_9_29()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_316_5_52() {
        Token xsp;
        if (this.jj_3R_addExpression_423_5_46()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_comparisonExpression_320_17_56());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_stringLiteral_600_5_48() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3_4() {
        Token xsp;
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_3R_primaryExpr_507_5_25()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_comparisonExpression_398_41_70());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(39);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_unaryExpr_480_9_13();
    }

    private boolean jj_3R_comparisonExpression_353_60_68() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_stringLiteral_600_5_48();
    }

    private boolean jj_3R_unaryExpr_494_13_19() {
        return this.jj_3R_primaryExpr_507_5_25();
    }

    private boolean jj_3R_unaryExpr_489_13_18() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_unaryExpr_480_9_13();
    }

    private boolean jj_3R_unaryExpr_481_17_16() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_unaryExpr_480_9_13();
    }

    private boolean jj_3R_comparisonExpression_369_33_66() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_3R_primaryExpr_507_5_25()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_comparisonExpression_377_41_69());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_equalityExpression_294_13_59() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_unaryExpr_484_13_17() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_unaryExpr_480_9_13();
    }

    private boolean jj_3R_functionExpression_657_30_34() {
        Token xsp;
        if (this.jj_3R_addExpression_423_5_46()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_functionExpression_657_75_47());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_identifier_677_9_21() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_literal_581_9_42() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_identifier_672_9_20() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_unaryExpr_480_9_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_unaryExpr_481_17_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_unaryExpr_484_13_17()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_unaryExpr_489_13_18()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_unaryExpr_494_13_19()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_literal_574_9_41() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_equalityExpression_283_13_58() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_3R_comparisonExpression_316_5_52();
    }

    private boolean jj_3R_identifier_671_5_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_identifier_672_9_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_identifier_677_9_21()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_3R_addExpression_423_5_46()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_addExpression_423_5_46();
    }

    private boolean jj_3R_equalityExpression_278_13_57() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_comparisonExpression_316_5_52();
    }

    private boolean jj_3R_equalityExpression_278_13_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_equalityExpression_278_13_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_equalityExpression_283_13_58()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_1()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_equalityExpression_294_13_59()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_literal_567_9_40() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_comparisonExpression_358_25_65() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_3R_addExpression_423_5_46()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_addExpression_423_5_46();
    }

    public ConfiguredObjectFilterParser(InputStream stream) {
        this(stream, null);
    }

    public ConfiguredObjectFilterParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ConfiguredObjectFilterParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public ConfiguredObjectFilterParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ConfiguredObjectFilterParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ConfiguredObjectFilterParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public ConfiguredObjectFilterParser(ConfiguredObjectFilterParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(ConfiguredObjectFilterParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

