/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import org.eclipse.jetty.websocket.api.exceptions.InvalidWebSocketException;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;

public class JettyWebSocketFrameHandlerMetadata
extends Configuration.ConfigurationCustomizer {
    private boolean autoDemand;
    private MethodHolder openHandle;
    private MethodHolder closeHandle;
    private MethodHolder errorHandle;
    private MethodHolder frameHandle;
    private MethodHolder textHandle;
    private Class<? extends MessageSink> textSink;
    private MethodHolder binaryHandle;
    private Class<? extends MessageSink> binarySink;
    private MethodHolder pingHandle;
    private MethodHolder pongHandle;

    public boolean isAutoDemand() {
        return this.autoDemand;
    }

    public void setAutoDemand(boolean autoDemand) {
        this.autoDemand = autoDemand;
    }

    public void setBinaryHandle(Class<? extends MessageSink> sinkClass, MethodHolder binary, Object origin) {
        this.assertNotSet(this.binaryHandle, "BINARY Handler", origin);
        this.assertNotSet(this.frameHandle, "FRAME Handler", origin);
        this.binaryHandle = binary;
        this.binarySink = sinkClass;
    }

    public MethodHolder getBinaryHandle() {
        return this.binaryHandle;
    }

    public Class<? extends MessageSink> getBinarySink() {
        return this.binarySink;
    }

    public void setCloseHandle(MethodHolder close, Object origin) {
        this.assertNotSet(this.closeHandle, "CLOSE Handler", origin);
        this.closeHandle = close;
    }

    public MethodHolder getCloseHandle() {
        return this.closeHandle;
    }

    public void setErrorHandle(MethodHolder error, Object origin) {
        this.assertNotSet(this.errorHandle, "ERROR Handler", origin);
        this.errorHandle = error;
    }

    public MethodHolder getErrorHandle() {
        return this.errorHandle;
    }

    public void setFrameHandle(MethodHolder frame, Object origin) {
        this.assertNotSet(this.frameHandle, "FRAME Handler", origin);
        this.assertNotSet(this.textHandle, "TEXT Handler", origin);
        this.assertNotSet(this.binaryHandle, "BINARY Handler", origin);
        this.assertNotSet(this.pingHandle, "PING Handler", origin);
        this.assertNotSet(this.pongHandle, "PONG Handler", origin);
        this.frameHandle = frame;
    }

    public MethodHolder getFrameHandle() {
        return this.frameHandle;
    }

    public void setOpenHandle(MethodHolder openHandle, Object origin) {
        this.assertNotSet(this.openHandle, "OPEN Handler", origin);
        this.openHandle = openHandle;
    }

    public MethodHolder getOpenHandle() {
        return this.openHandle;
    }

    public void setPingHandle(MethodHolder ping, Object origin) {
        this.assertNotSet(this.pingHandle, "PING Handler", origin);
        this.assertNotSet(this.frameHandle, "FRAME Handler", origin);
        this.pingHandle = ping;
    }

    public MethodHolder getPingHandle() {
        return this.pingHandle;
    }

    public void setPongHandle(MethodHolder pong, Object origin) {
        this.assertNotSet(this.pongHandle, "PONG Handler", origin);
        this.assertNotSet(this.frameHandle, "FRAME Handler", origin);
        this.pongHandle = pong;
    }

    public MethodHolder getPongHandle() {
        return this.pongHandle;
    }

    public void setTextHandle(Class<? extends MessageSink> sinkClass, MethodHolder text, Object origin) {
        this.assertNotSet(this.textHandle, "TEXT Handler", origin);
        this.assertNotSet(this.frameHandle, "FRAME Handler", origin);
        this.textHandle = text;
        this.textSink = sinkClass;
    }

    public MethodHolder getTextHandle() {
        return this.textHandle;
    }

    public Class<? extends MessageSink> getTextSink() {
        return this.textSink;
    }

    private void assertNotSet(Object val, String role, Object origin) {
        if (val == null) {
            return;
        }
        StringBuilder err = new StringBuilder();
        err.append("Cannot replace previously assigned [");
        err.append(role);
        err.append("] at ").append(this.describeOrigin(val));
        err.append(" with ");
        err.append(this.describeOrigin(origin));
        throw new InvalidWebSocketException(err.toString());
    }

    private String describeOrigin(Object obj) {
        if (obj == null) {
            return "<undefined>";
        }
        return obj.toString();
    }
}

