/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class AsyncCommand {
    private final CompletableFuture<Void> _future;
    private ServerTransaction.Action _action;

    public AsyncCommand(CompletableFuture<Void> future, ServerTransaction.Action action) {
        this._future = future;
        this._action = action;
    }

    public void complete() {
        boolean interrupted = false;
        boolean success = false;
        try {
            while (true) {
                try {
                    this._future.get();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            success = true;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new ServerScopedRuntimeException(e.getCause());
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (success) {
                this._action.postCommit();
            } else {
                this._action.onRollback();
            }
            this._action = null;
        }
    }

    public boolean isReadyForCompletion() {
        return this._future.isDone();
    }
}

