/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.limit;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.security.limit.ConnectionLimiter;
import org.apache.qpid.server.security.limit.ConnectionSlot;
import org.apache.qpid.server.transport.AMQPConnection;

public class CachedConnectionLimiterImpl
implements ConnectionLimiter.CachedLimiter {
    private final Map<AMQPConnection<?>, ConnectionSlot> _cache = new ConcurrentHashMap();
    private final AtomicReference<ConnectionLimiter> _limiter;

    public CachedConnectionLimiterImpl(ConnectionLimiter limiter) {
        this._limiter = new AtomicReference<ConnectionLimiter>(Objects.requireNonNull(limiter));
    }

    @Override
    public ConnectionSlot register(AMQPConnection<?> connection) {
        return this._cache.computeIfAbsent(connection, this::newConnectionSlot);
    }

    @Override
    public boolean deregister(AMQPConnection<?> connection) {
        ConnectionSlot connectionSlot = this._cache.get(connection);
        if (connectionSlot != null) {
            connectionSlot.free();
            return true;
        }
        return false;
    }

    @Override
    public ConnectionLimiter append(ConnectionLimiter limiter) {
        return this._limiter.get().append(limiter);
    }

    protected void swapLimiter(ConnectionLimiter limiter) {
        this._limiter.set(Objects.requireNonNull(limiter));
    }

    private ConnectionSlot newConnectionSlot(AMQPConnection<?> connection) {
        return new ConnectionSlotImpl(connection, this._limiter.get().register(connection));
    }

    private final class ConnectionSlotImpl
    implements ConnectionSlot {
        private final AMQPConnection<?> _connection;
        private final ConnectionSlot _slot;

        ConnectionSlotImpl(AMQPConnection<?> connection, ConnectionSlot slot) {
            this._connection = Objects.requireNonNull(connection);
            this._slot = Objects.requireNonNull(slot);
        }

        @Override
        public void free() {
            if (CachedConnectionLimiterImpl.this._cache.remove(this._connection, this)) {
                this._slot.free();
            }
        }
    }
}

