/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group.cloudfoundry;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.TrustStore;

@ManagedObject(category=false, type="CloudFoundryDashboardManagement")
public interface CloudFoundryDashboardManagementGroupProvider<X extends CloudFoundryDashboardManagementGroupProvider<X>>
extends GroupProvider<X> {
    public static final String QPID_GROUPPROVIDER_CLOUDFOUNDRY_CONNECT_TIMEOUT = "qpid.groupprovider.cloudfoundry.connectTimeout";
    @ManagedContextDefault(name="qpid.groupprovider.cloudfoundry.connectTimeout")
    public static final int DEFAULT_QPID_GROUPPROVIDER_CLOUDFOUNDRY_CONNECT_TIMEOUT = 60000;
    public static final String QPID_GROUPPROVIDER_CLOUDFOUNDRY_READ_TIMEOUT = "qpid.groupprovider.cloudfoundry.readTimeout";
    @ManagedContextDefault(name="qpid.groupprovider.cloudfoundry.readTimeout")
    public static final int DEFAULT_QPID_GROUPPROVIDER_CLOUDFOUNDRY_READ_TIMEOUT = 60000;

    @ManagedAttribute(description="The CloudFoundry dashboard SSO base URI. The API version and service instance information will be appended by this GroupProvider.", mandatory=true)
    public URI getCloudFoundryEndpointURI();

    @ManagedAttribute(description="The TrustStore that contains the CA certificate that signed the CloudFoundry endpoint.")
    public TrustStore getTrustStore();

    @ManagedAttribute(description="A service instance id to qpid management group mapping. If the CloudFoundry endpoint grants a user permission to manage a service instance the user will be associated with the corresponding management group.", mandatory=true)
    public Map<String, String> getServiceToManagementGroupMapping();

    @DerivedAttribute
    public List<String> getTlsProtocolAllowList();

    @DerivedAttribute
    public List<String> getTlsProtocolDenyList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteAllowList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteDenyList();
}

