/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.server.queue.AbstractQueue;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueConsumerManager;
import org.apache.qpid.server.queue.QueueConsumerNode;
import org.apache.qpid.server.queue.QueueConsumerNodeList;
import org.apache.qpid.server.queue.QueueConsumerNodeListEntry;

public class QueueConsumerManagerImpl
implements QueueConsumerManager {
    private static final EnumSet<NodeState> REMOVED = EnumSet.of(NodeState.REMOVED);
    private static final EnumSet<NodeState> STATES_OTHER_THAN_REMOVED = EnumSet.complementOf(REMOVED);
    private static final EnumSet<NodeState> NOT_INTERESTED = EnumSet.of(NodeState.NOT_INTERESTED);
    private static final EnumSet<NodeState> EITHER_INTERESTED_OR_NOTIFIED = EnumSet.of(NodeState.INTERESTED, NodeState.NOTIFIED);
    private static final EnumSet<NodeState> NON_ACQUIRING = EnumSet.of(NodeState.NON_ACQUIRING);
    private static final EnumSet<NodeState> INTERESTED = EnumSet.of(NodeState.INTERESTED);
    private static final EnumSet<NodeState> NOTIFIED = EnumSet.of(NodeState.NOTIFIED);
    private final AbstractQueue<?> _queue;
    private final List<PriorityConsumerListPair> _interested;
    private final QueueConsumerNodeList _notInterested;
    private final List<PriorityConsumerListPair> _notified;
    private final QueueConsumerNodeList _nonAcquiring;
    private final List<PriorityConsumerListPair> _allConsumers;
    private volatile int _count;

    public QueueConsumerManagerImpl(AbstractQueue<?> queue) {
        this._queue = queue;
        this._notInterested = new QueueConsumerNodeList(queue);
        this._interested = new CopyOnWriteArrayList<PriorityConsumerListPair>();
        this._notified = new CopyOnWriteArrayList<PriorityConsumerListPair>();
        this._nonAcquiring = new QueueConsumerNodeList(queue);
        this._allConsumers = new CopyOnWriteArrayList<PriorityConsumerListPair>();
    }

    @Override
    public void addConsumer(QueueConsumer<?, ?> consumer) {
        QueueConsumerNode node = new QueueConsumerNode(this, consumer);
        consumer.setQueueConsumerNode(node);
        this.addToAll(node);
        if (consumer.isNotifyWorkDesired()) {
            if (consumer.acquires()) {
                node.moveFromTo(REMOVED, NodeState.INTERESTED);
            } else {
                node.moveFromTo(REMOVED, NodeState.NON_ACQUIRING);
            }
        } else {
            node.moveFromTo(REMOVED, NodeState.NOT_INTERESTED);
        }
        ++this._count;
    }

    @Override
    public boolean removeConsumer(QueueConsumer<?, ?> consumer) {
        this.removeFromAll(consumer);
        QueueConsumerNode node = consumer.getQueueConsumerNode();
        if (node.moveFromTo(STATES_OTHER_THAN_REMOVED, NodeState.REMOVED)) {
            --this._count;
            return true;
        }
        return false;
    }

    @Override
    public boolean setInterest(QueueConsumer<?, ?> consumer, boolean interested) {
        QueueConsumerNode node = consumer.getQueueConsumerNode();
        if (interested) {
            if (consumer.acquires()) {
                return node.moveFromTo(NOT_INTERESTED, NodeState.INTERESTED);
            }
            return node.moveFromTo(NOT_INTERESTED, NodeState.NON_ACQUIRING);
        }
        if (consumer.acquires()) {
            return node.moveFromTo(EITHER_INTERESTED_OR_NOTIFIED, NodeState.NOT_INTERESTED);
        }
        return node.moveFromTo(NON_ACQUIRING, NodeState.NOT_INTERESTED);
    }

    @Override
    public boolean setNotified(QueueConsumer<?, ?> consumer, boolean notified) {
        QueueConsumerNode node = consumer.getQueueConsumerNode();
        if (consumer.acquires()) {
            if (notified) {
                return node.moveFromTo(INTERESTED, NodeState.NOTIFIED);
            }
            return node.moveFromTo(NOTIFIED, NodeState.INTERESTED);
        }
        return true;
    }

    @Override
    public Iterator<QueueConsumer<?, ?>> getInterestedIterator() {
        return new QueueConsumerIterator(new PrioritisedQueueConsumerNodeIterator(this._interested));
    }

    @Override
    public Iterator<QueueConsumer<?, ?>> getAllIterator() {
        return new QueueConsumerIterator(new PrioritisedQueueConsumerNodeIterator(this._allConsumers));
    }

    @Override
    public Iterator<QueueConsumer<?, ?>> getNonAcquiringIterator() {
        return new QueueConsumerIterator(this._nonAcquiring.iterator());
    }

    @Override
    public int getAllSize() {
        return this._count;
    }

    @Override
    public int getHighestNotifiedPriority() {
        PrioritisedQueueConsumerNodeIterator notifiedIterator = new PrioritisedQueueConsumerNodeIterator(this._notified);
        if (notifiedIterator.hasNext()) {
            QueueConsumerNode queueConsumerNode = (QueueConsumerNode)notifiedIterator.next();
            return queueConsumerNode.getQueueConsumer().getPriority();
        }
        return Integer.MIN_VALUE;
    }

    QueueConsumerNodeListEntry addNodeToInterestList(QueueConsumerNode queueConsumerNode) {
        QueueConsumerNodeListEntry newListEntry;
        block0 : switch (queueConsumerNode.getState()) {
            case INTERESTED: {
                newListEntry = null;
                for (PriorityConsumerListPair pair : this._interested) {
                    if (pair._priority != queueConsumerNode.getQueueConsumer().getPriority()) continue;
                    newListEntry = pair._consumers.add(queueConsumerNode);
                    break block0;
                }
                break;
            }
            case NOT_INTERESTED: {
                newListEntry = this._notInterested.add(queueConsumerNode);
                break;
            }
            case NOTIFIED: {
                newListEntry = null;
                for (PriorityConsumerListPair pair : this._notified) {
                    if (pair._priority != queueConsumerNode.getQueueConsumer().getPriority()) continue;
                    newListEntry = pair._consumers.add(queueConsumerNode);
                    break block0;
                }
                break;
            }
            case NON_ACQUIRING: {
                newListEntry = this._nonAcquiring.add(queueConsumerNode);
                break;
            }
            default: {
                newListEntry = null;
            }
        }
        return newListEntry;
    }

    private void addToAll(QueueConsumerNode consumerNode) {
        int i;
        int consumerPriority = consumerNode.getQueueConsumer().getPriority();
        for (i = 0; i < this._allConsumers.size(); ++i) {
            PriorityConsumerListPair priorityConsumerListPair = this._allConsumers.get(i);
            if (priorityConsumerListPair._priority == consumerPriority) {
                QueueConsumerNodeListEntry entry = priorityConsumerListPair._consumers.add(consumerNode);
                consumerNode.setAllEntry(entry);
                return;
            }
            if (priorityConsumerListPair._priority < consumerPriority) break;
        }
        PriorityConsumerListPair newPriorityConsumerListPair = new PriorityConsumerListPair(consumerPriority);
        QueueConsumerNodeListEntry entry = newPriorityConsumerListPair._consumers.add(consumerNode);
        consumerNode.setAllEntry(entry);
        this._allConsumers.add(i, newPriorityConsumerListPair);
        this._notified.add(i, new PriorityConsumerListPair(consumerPriority));
        this._interested.add(i, new PriorityConsumerListPair(consumerPriority));
    }

    private void removeFromAll(QueueConsumer<?, ?> consumer) {
        QueueConsumerNode node = consumer.getQueueConsumerNode();
        int consumerPriority = consumer.getPriority();
        for (int i = 0; i < this._allConsumers.size(); ++i) {
            PriorityConsumerListPair priorityConsumerListPair = this._allConsumers.get(i);
            if (priorityConsumerListPair._priority == consumerPriority) {
                priorityConsumerListPair._consumers.removeEntry(node.getAllEntry());
                if (priorityConsumerListPair._consumers.isEmpty()) {
                    this._allConsumers.remove(i);
                    this._notified.remove(i);
                    this._interested.remove(i);
                }
                return;
            }
            if (priorityConsumerListPair._priority < consumerPriority) break;
        }
    }

    static enum NodeState {
        REMOVED,
        INTERESTED,
        NOT_INTERESTED,
        NOTIFIED,
        NON_ACQUIRING;

    }

    private static class QueueConsumerIterator
    implements Iterator<QueueConsumer<?, ?>> {
        private final Iterator<QueueConsumerNode> _underlying;

        private QueueConsumerIterator(Iterator<QueueConsumerNode> underlying) {
            this._underlying = underlying;
        }

        @Override
        public boolean hasNext() {
            return this._underlying.hasNext();
        }

        @Override
        public QueueConsumer<?, ?> next() {
            return this._underlying.next().getQueueConsumer();
        }

        @Override
        public void remove() {
            this._underlying.remove();
        }
    }

    private class PrioritisedQueueConsumerNodeIterator
    implements Iterator<QueueConsumerNode> {
        final Iterator<PriorityConsumerListPair> _outerIterator;
        Iterator<QueueConsumerNode> _innerIterator;

        private PrioritisedQueueConsumerNodeIterator(List<PriorityConsumerListPair> list) {
            this._outerIterator = list.iterator();
            this._innerIterator = Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this._innerIterator.hasNext()) {
                    return true;
                }
                if (!this._outerIterator.hasNext()) break;
                PriorityConsumerListPair priorityConsumersPair = this._outerIterator.next();
                this._innerIterator = priorityConsumersPair._consumers.iterator();
            }
            return false;
        }

        @Override
        public QueueConsumerNode next() {
            try {
                return this._innerIterator.next();
            }
            catch (NoSuchElementException e) {
                this.hasNext();
                return this._innerIterator.next();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PriorityConsumerListPair {
        final int _priority;
        final QueueConsumerNodeList _consumers;

        private PriorityConsumerListPair(int priority) {
            this._priority = priority;
            this._consumers = new QueueConsumerNodeList(QueueConsumerManagerImpl.this._queue);
        }
    }
}

