/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.server.model.OperationParameter;
import org.apache.qpid.server.model.Param;

public class OperationParameterFromAnnotation
implements OperationParameter {
    private final Param _param;
    private final Class<?> _type;
    private final Type _genericType;

    public OperationParameterFromAnnotation(Param param, Class<?> type, Type genericType) {
        this._param = param;
        this._type = type;
        this._genericType = genericType;
    }

    @Override
    public String getName() {
        return this._param.name();
    }

    @Override
    public String getDefaultValue() {
        return this._param.defaultValue();
    }

    @Override
    public String getDescription() {
        return this._param.description();
    }

    @Override
    public List<String> getValidValues() {
        return Collections.unmodifiableList(Arrays.asList(this._param.validValues()));
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public Type getGenericType() {
        return this._genericType;
    }

    @Override
    public boolean isMandatory() {
        return this._param.mandatory() || this._type.isPrimitive();
    }

    @Override
    public boolean isCompatible(OperationParameter that) {
        if (!this._param.name().equals(that.getName())) {
            return false;
        }
        if (this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null) {
            return false;
        }
        return !(this.getGenericType() == null ? that.getGenericType() != null : !this.getGenericType().equals(that.getGenericType()));
    }
}

