/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.retriever;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.query.engine.retriever.ConfiguredObjectRetriever;
import org.apache.qpid.server.query.engine.retriever.EntityRetriever;
import org.apache.qpid.server.security.access.config.AclFileParser;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.plugins.AclFileAccessControlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclRuleRetriever<C extends ConfiguredObject<?>>
extends ConfiguredObjectRetriever<C>
implements EntityRetriever<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclRuleRetriever.class);
    private final Class<C> _type = AccessControlProvider.class;
    private final List<String> _fieldNames = List.of("identity", "attributes", "objectType", "operation", "outcome");
    private final Function<Rule, Map<String, Object>> _ruleMapping = rule -> Map.of(this._fieldNames.get(0), rule.getIdentity(), this._fieldNames.get(1), rule.getAttributes(), this._fieldNames.get(2), rule.getObjectType(), this._fieldNames.get(3), rule.getOperation(), this._fieldNames.get(4), rule.getOutcome());
    private RuleSet _ruleSet;

    @Override
    public Stream<Map<String, ?>> retrieve(C broker) {
        Stream<AccessControlProvider> stream = this.retrieve(broker, this._type).map(child -> (AccessControlProvider)child);
        return stream.flatMap(provider -> {
            if (provider instanceof AclFileAccessControlProvider) {
                try {
                    if (this._ruleSet == null) {
                        this._ruleSet = AclFileParser.parse((String)((AclFileAccessControlProvider)provider).getPath(), EventLogger::new);
                    }
                    return this._ruleSet.stream().map(this._ruleMapping);
                }
                catch (IllegalConfigurationException e) {
                    LOGGER.error("Error when retrieving ACL rules", (Throwable)e);
                    return Stream.empty();
                }
            }
            return Stream.empty();
        });
    }

    @Override
    public List<String> getFieldNames() {
        return this._fieldNames;
    }
}

