/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import java.math.BigDecimal;
import java.util.Objects;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.literal.NullLiteralExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.NumberLiteralExpression;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;

public final class UnaryExpressionFactory {
    private UnaryExpressionFactory() {
    }

    public static <T, R> ExpressionNode<T, R> negate(ExpressionNode<T, R> expression) {
        Objects.requireNonNull(expression, "Child expression should be not null");
        if (expression instanceof NumberLiteralExpression) {
            NumberLiteralExpression numberLiteralExpression = (NumberLiteralExpression)expression;
            Number number = (Number)numberLiteralExpression.get();
            if (number == null) {
                return new NullLiteralExpression();
            }
            return new NumberLiteralExpression((Number)NumberConverter.narrow(BigDecimal.ZERO.subtract(new BigDecimal(number.toString()))));
        }
        throw QueryParsingException.of("Negation of '%s' not supported", StringUtils.getClassName(expression));
    }
}

