/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.string;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class ConcatExpression<T, R>
extends AbstractFunctionExpression<T, String> {
    private final FunctionParameterTypePredicate<R> _typeValidator = FunctionParameterTypePredicate.builder().allowNulls().allowBooleans().allowEnums().allowDateTimeTypes().allowNumbers().allowStrings().build();

    public ConcatExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireMinParameters(1, args, this);
    }

    @Override
    public String apply(T value) {
        List args = this.getChildren().stream().map(expression -> expression.apply(value)).collect(Collectors.toList());
        if (args.stream().anyMatch(Objects::isNull)) {
            return "";
        }
        List invalidArgs = args.stream().filter(this._typeValidator.negate()).map(StringUtils::getClassName).collect(Collectors.toList());
        if (!invalidArgs.isEmpty()) {
            throw QueryParsingException.of("Parameters of function '%s' invalid (invalid types: %s)", this._functionName, invalidArgs);
        }
        return args.stream().map(DateTimeConverter.toStringMapper()).map(String::valueOf).collect(Collectors.joining(""));
    }
}

