/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.ReplicationSSLConfig;
import com.sleepycat.je.rep.net.InstanceContext;
import com.sleepycat.je.rep.net.InstanceLogger;
import com.sleepycat.je.rep.net.InstanceParams;
import com.sleepycat.je.rep.utilint.net.SSLChannelFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

class SSLMirrorMatcher {
    private final Principal ourPrincipal;
    private final InstanceLogger logger;

    public SSLMirrorMatcher(InstanceParams params, boolean clientMode) throws IllegalArgumentException {
        this.ourPrincipal = this.determinePrincipal(params.getContext(), clientMode);
        if (this.ourPrincipal == null) {
            throw new IllegalArgumentException("Unable to determine a local principal for comparison with peer principals");
        }
        this.logger = params.getContext().getLoggerFactory().getLogger(this.getClass());
    }

    public boolean peerMatches(SSLSession sslSession) {
        if (this.ourPrincipal == null) {
            return false;
        }
        Principal peerPrincipal = null;
        try {
            peerPrincipal = sslSession.getPeerPrincipal();
        }
        catch (SSLPeerUnverifiedException pue) {
            return false;
        }
        if (peerPrincipal == null || !(peerPrincipal instanceof X500Principal)) {
            this.logger.log(Level.INFO, "Unable to attempt peer validation - peer Principal is: " + peerPrincipal);
            return false;
        }
        return this.ourPrincipal.equals(peerPrincipal);
    }

    private Principal determinePrincipal(InstanceContext context, boolean clientMode) throws IllegalArgumentException {
        ReplicationSSLConfig config = (ReplicationSSLConfig)context.getRepNetConfig();
        String aliasProp = clientMode ? config.getSSLClientKeyAlias() : config.getSSLServerKeyAlias();
        KeyStore keyStore = SSLChannelFactory.readKeyStore(context);
        if (aliasProp == null || aliasProp.isEmpty()) {
            try {
                if (keyStore.size() < 1) {
                    this.logger.log(Level.INFO, "KeyStore is empty");
                    return null;
                }
                if (keyStore.size() > 1) {
                    this.logger.log(Level.INFO, "KeyStore has multiple entries but no alias was specified.  Using the first one available.");
                }
                Enumeration<String> e = keyStore.aliases();
                aliasProp = e.nextElement();
            }
            catch (KeyStoreException kse) {
                throw new IllegalArgumentException("Error accessing aliases from the keystore", kse);
            }
        }
        Certificate cert = null;
        try {
            cert = keyStore.getCertificate(aliasProp);
        }
        catch (KeyStoreException kse) {
            throw new IllegalArgumentException("Error accessing certificate with alias " + aliasProp + " from the keystore", kse);
        }
        if (cert == null) {
            this.logger.log(Level.INFO, "No certificate for alias " + aliasProp + " found in KeyStore");
            throw new IllegalArgumentException("Unable to find a certificate in the keystore");
        }
        if (!(cert instanceof X509Certificate)) {
            this.logger.log(Level.INFO, "The certificate for alias " + aliasProp + " is not an X509Certificate.");
            throw new IllegalArgumentException("Unable to find a valid certificate in the keystore");
        }
        X509Certificate x509Cert = (X509Certificate)cert;
        return x509Cert.getSubjectX500Principal();
    }
}

