/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.ForwardCursor;
import com.sleepycat.je.Get;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.SearchMode;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;

public class JoinCursor
implements ForwardCursor,
Closeable {
    private JoinConfig config;
    private Database priDb;
    private Cursor[] secCursors;
    private DatabaseEntry[] cursorScratchEntries;
    private DatabaseEntry scratchEntry;
    private DatabaseEntry firstSecKey;
    private boolean[] cursorFetchedFirst;

    JoinCursor(Database primaryDb, final Cursor[] cursors, JoinConfig configParam) throws DatabaseException {
        this.priDb = primaryDb;
        this.config = configParam != null ? configParam.clone() : JoinConfig.DEFAULT;
        this.scratchEntry = new DatabaseEntry();
        this.firstSecKey = new DatabaseEntry();
        this.cursorScratchEntries = new DatabaseEntry[cursors.length];
        for (int i = 0; i < cursors.length; ++i) {
            this.cursorScratchEntries[i] = new DatabaseEntry();
        }
        this.cursorFetchedFirst = new boolean[cursors.length];
        Cursor[] sortedCursors = new Cursor[cursors.length];
        System.arraycopy(cursors, 0, sortedCursors, 0, cursors.length);
        if (!this.config.getNoSort()) {
            final long[] counts = new long[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                counts[i] = cursors[i].countEstimateInternal();
                assert (counts[i] >= 0L);
            }
            Arrays.sort(sortedCursors, new Comparator<Cursor>(){

                @Override
                public int compare(Cursor o1, Cursor o2) {
                    long count1 = -1L;
                    long count2 = -1L;
                    for (int i = 0; i < cursors.length && (count1 < 0L || count2 < 0L); ++i) {
                        if (cursors[i] == o1) {
                            count1 = counts[i];
                            continue;
                        }
                        if (cursors[i] != o2) continue;
                        count2 = counts[i];
                    }
                    assert (count1 >= 0L && count2 >= 0L);
                    long cmp = count1 - count2;
                    return cmp < 0L ? -1 : (cmp > 0L ? 1 : 0);
                }
            });
        }
        try {
            this.secCursors = new Cursor[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                this.secCursors[i] = sortedCursors[i].dup(true);
            }
        }
        catch (DatabaseException e) {
            this.close(e);
        }
    }

    @Override
    public void close() throws DatabaseException {
        if (this.priDb == null) {
            return;
        }
        this.close(null);
    }

    private void close(DatabaseException firstException) throws DatabaseException {
        this.priDb = null;
        for (int i = 0; i < this.secCursors.length; ++i) {
            block4: {
                if (this.secCursors[i] == null) continue;
                try {
                    this.secCursors[i].close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block4;
                    firstException = e;
                }
            }
            this.secCursors[i] = null;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    Cursor[] getSortedCursors() {
        return this.secCursors;
    }

    @Override
    public Database getDatabase() {
        return this.priDb;
    }

    public JoinConfig getConfig() {
        return this.config.clone();
    }

    @Override
    public OperationResult get(DatabaseEntry key, DatabaseEntry data, Get getType, ReadOptions options) {
        if (getType != Get.NEXT) {
            throw new IllegalArgumentException("Get type not allowed: " + (Object)((Object)getType));
        }
        LockMode lockMode = options != null ? options.getLockMode() : null;
        CacheMode cacheMode = options != null ? options.getCacheMode() : null;
        try {
            this.secCursors[0].checkEnv();
            this.secCursors[0].trace(Level.FINEST, getType.toString(), lockMode);
            return this.retrieveNext(key, data, lockMode, cacheMode);
        }
        catch (Error E) {
            this.priDb.getEnv().invalidate(E);
            throw E;
        }
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw new UnsupportedOperationException();
    }

    public OperationStatus getNext(DatabaseEntry key, LockMode lockMode) {
        return this.getNext(key, null, lockMode);
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.NEXT, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    private OperationResult retrieveNext(DatabaseEntry keyParam, DatabaseEntry dataParam, LockMode lockMode, CacheMode cacheMode) {
        OperationResult result;
        DatabaseEntry candidateKey;
        block9: {
            boolean readUncommitted = this.secCursors[0].isReadUncommittedMode(lockMode);
            block0: while (true) {
                Cursor secCursor = this.secCursors[0];
                candidateKey = this.cursorScratchEntries[0];
                if (!this.cursorFetchedFirst[0]) {
                    result = secCursor.getCurrentInternal(this.firstSecKey, candidateKey, lockMode, cacheMode);
                    if (readUncommitted && result == null) {
                        this.cursorFetchedFirst[0] = true;
                        continue;
                    }
                    this.cursorFetchedFirst[0] = true;
                } else {
                    result = secCursor.retrieveNext(this.firstSecKey, candidateKey, lockMode, cacheMode, GetMode.NEXT_DUP);
                }
                if (result == null) {
                    return null;
                }
                for (int i = 1; i < this.secCursors.length; ++i) {
                    secCursor = this.secCursors[i];
                    DatabaseEntry secKey = this.cursorScratchEntries[i];
                    if (!this.cursorFetchedFirst[i]) {
                        result = secCursor.getCurrentInternal(secKey, this.scratchEntry, lockMode, cacheMode);
                        if (readUncommitted && result == null && (result = secCursor.retrieveNext(secKey, this.scratchEntry, lockMode, cacheMode, GetMode.NEXT_DUP)) == null) {
                            return null;
                        }
                        this.cursorFetchedFirst[i] = true;
                    }
                    this.scratchEntry.setData(secKey.getData(), secKey.getOffset(), secKey.getSize());
                    result = secCursor.search(this.scratchEntry, candidateKey, lockMode, cacheMode, SearchMode.BOTH, true);
                    if (result == null) continue block0;
                }
                if (dataParam == null) break block9;
                if (this.secCursors[0].readPrimaryAfterGet(this.priDb, this.firstSecKey, candidateKey, dataParam, lockMode, readUncommitted, false)) break;
            }
            CursorImpl firstSecCursor = this.secCursors[0].cursorImpl;
            for (int i = 1; i < this.secCursors.length; ++i) {
                this.secCursors[i].cursorImpl.setPriInfo(firstSecCursor);
            }
        }
        keyParam.setData(candidateKey.getData(), candidateKey.getOffset(), candidateKey.getSize());
        return result;
    }
}

