/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.apache.qpid.server.consumer.ConsumerOption;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageContainer;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.StateChangeListener;

public abstract class AbstractSystemMessageSource
implements MessageSource {
    private final List<Consumer<?>> _consumers = new CopyOnWriteArrayList();
    protected final UUID _id;
    protected final String _name;
    protected final NamedAddressSpace _addressSpace;

    public AbstractSystemMessageSource(String name, NamedAddressSpace addressSpace) {
        this._name = name;
        this._id = UUID.nameUUIDFromBytes((this.getClass().getSimpleName() + "/" + addressSpace.getName() + "/" + name).getBytes(StandardCharsets.UTF_8));
        this._addressSpace = addressSpace;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public MessageDurability getMessageDurability() {
        return MessageDurability.NEVER;
    }

    public <T extends ConsumerTarget<T>> Consumer<T> addConsumer(T target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerOption> options, Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ConsumerAccessRefused, MessageSource.QueueDeleted {
        Consumer consumer = new Consumer(this, consumerName, target);
        target.consumerAdded(consumer);
        this._consumers.add(consumer);
        return consumer;
    }

    public Collection<Consumer<?>> getConsumers() {
        return new ArrayList(this._consumers);
    }

    @Override
    public boolean verifySessionAccess(AMQPSession<?, ?> session) {
        return true;
    }

    @Override
    public MessageSource.MessageConversionExceptionHandlingPolicy getMessageConversionExceptionHandlingPolicy() {
        return MessageSource.MessageConversionExceptionHandlingPolicy.CLOSE;
    }

    protected static class Consumer<T extends ConsumerTarget>
    implements MessageInstanceConsumer<T>,
    TransactionLogResource {
        private final List<PropertiesMessageInstance> _queue = Collections.synchronizedList(new ArrayList());
        private final T _target;
        private final String _name;
        private final UUID _identifier = UUID.randomUUID();
        final /* synthetic */ AbstractSystemMessageSource this$0;

        public Consumer(String consumerName, T target) {
            this.this$0 = this$0;
            this._name = consumerName;
            this._target = target;
        }

        @Override
        public void externalStateChange() {
            if (!this._queue.isEmpty()) {
                this._target.notifyWork();
            }
        }

        @Override
        public Object getIdentifier() {
            return this._identifier;
        }

        @Override
        public T getTarget() {
            return this._target;
        }

        @Override
        public MessageContainer pullMessage() {
            if (!this._queue.isEmpty()) {
                PropertiesMessageInstance propertiesMessageInstance = this._queue.get(0);
                if (!this._target.isSuspended() && this._target.allocateCredit(propertiesMessageInstance.getMessage())) {
                    this._queue.remove(0);
                    return new MessageContainer(propertiesMessageInstance, propertiesMessageInstance.getMessageReference());
                }
            } else {
                this._target.noMessagesAvailable();
            }
            return null;
        }

        @Override
        public void setNotifyWorkDesired(boolean desired) {
            if (desired && !this._queue.isEmpty()) {
                this._target.notifyWork();
            }
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public boolean acquires() {
            return true;
        }

        @Override
        public void close() {
            this._queue.forEach(PropertiesMessageInstance::delete);
            this.this$0._consumers.remove(this);
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public UUID getId() {
            return this._identifier;
        }

        @Override
        public MessageDurability getMessageDurability() {
            return MessageDurability.NEVER;
        }

        public void send(InternalMessage response) {
            this._queue.add(this.this$0.new PropertiesMessageInstance(this, response));
            this._target.notifyWork();
        }
    }

    class PropertiesMessageInstance
    implements MessageInstance {
        private final Consumer _consumer;
        private final MessageReference _messageReference;
        private final InternalMessage _message;
        private int _deliveryCount;
        private boolean _isRedelivered;
        private boolean _isDelivered;
        private boolean _isDeleted;

        PropertiesMessageInstance(Consumer consumer, InternalMessage message) {
            this._consumer = consumer;
            this._message = message;
            this._messageReference = message.newReference(consumer);
        }

        @Override
        public int getDeliveryCount() {
            return 0;
        }

        @Override
        public void incrementDeliveryCount() {
            ++this._deliveryCount;
        }

        @Override
        public void decrementDeliveryCount() {
            --this._deliveryCount;
        }

        @Override
        public void addStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
        }

        @Override
        public boolean removeStateChangeListener(StateChangeListener<? super MessageInstance, MessageInstance.EntryState> listener) {
            return false;
        }

        @Override
        public boolean acquiredByConsumer() {
            return !this.isDeleted();
        }

        public Consumer getAcquiringConsumer() {
            return this._consumer;
        }

        @Override
        public MessageEnqueueRecord getEnqueueRecord() {
            return null;
        }

        @Override
        public boolean isAcquiredBy(MessageInstanceConsumer<?> consumer) {
            return consumer == this._consumer && !this.isDeleted();
        }

        @Override
        public boolean removeAcquisitionFromConsumer(MessageInstanceConsumer<?> consumer) {
            return consumer == this._consumer;
        }

        @Override
        public void setRedelivered() {
            this._isRedelivered = true;
        }

        @Override
        public boolean isRedelivered() {
            return this._isRedelivered;
        }

        @Override
        public void reject(MessageInstanceConsumer<?> consumer) {
            this.delete();
        }

        @Override
        public boolean isRejectedBy(MessageInstanceConsumer<?> consumer) {
            return false;
        }

        @Override
        public boolean getDeliveredToConsumer() {
            return this._isDelivered;
        }

        @Override
        public boolean expired() {
            return false;
        }

        @Override
        public boolean acquire(MessageInstanceConsumer<?> consumer) {
            return false;
        }

        @Override
        public boolean makeAcquisitionUnstealable(MessageInstanceConsumer<?> consumer) {
            return false;
        }

        @Override
        public boolean makeAcquisitionStealable() {
            return false;
        }

        @Override
        public int getMaximumDeliveryCount() {
            return 0;
        }

        @Override
        public int routeToAlternate(Action<? super MessageInstance> action, ServerTransaction txn, Predicate<BaseQueue> predicate) {
            return 0;
        }

        @Override
        public Filterable asFilterable() {
            return null;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public boolean acquire() {
            return false;
        }

        @Override
        public boolean isAcquired() {
            return !this.isDeleted();
        }

        @Override
        public void release() {
            this.delete();
        }

        @Override
        public void release(MessageInstanceConsumer<?> consumer) {
            if (this.isAcquiredBy(consumer)) {
                this.release();
            }
        }

        @Override
        public void delete() {
            this._messageReference.release();
            this._isDeleted = true;
        }

        @Override
        public boolean isDeleted() {
            return this._isDeleted;
        }

        @Override
        public boolean isHeld() {
            return false;
        }

        @Override
        public boolean isPersistent() {
            return false;
        }

        @Override
        public ServerMessage getMessage() {
            return this._message;
        }

        @Override
        public InstanceProperties getInstanceProperties() {
            return InstanceProperties.EMPTY;
        }

        @Override
        public TransactionLogResource getOwningResource() {
            return AbstractSystemMessageSource.this;
        }

        public MessageReference getMessageReference() {
            return this._messageReference;
        }
    }
}

