/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static byte[] readFileAsBytes(String filename) {
        byte[] byArray;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));
        try {
            byArray = FileUtils.readStreamAsString(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        is.close();
        return byArray;
    }

    public static String readFileAsString(String filename) {
        return new String(FileUtils.readFileAsBytes(filename));
    }

    public static String readFileAsString(File file) {
        String string;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            string = new String(FileUtils.readStreamAsString(is));
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        is.close();
        return string;
    }

    private static byte[] readStreamAsString(BufferedInputStream is) {
        byte[] byArray;
        ByteArrayOutputStream inBuffer = new ByteArrayOutputStream();
        try {
            int read;
            byte[] data = new byte[4096];
            while ((read = is.read(data)) != -1) {
                inBuffer.write(data, 0, read);
            }
            byArray = inBuffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inBuffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inBuffer.close();
        return byArray;
    }

    public static InputStream openFileOrDefaultResource(String filename, String defaultResource, ClassLoader cl) {
        InputStream is = null;
        if (filename != null) {
            try {
                is = new BufferedInputStream(new FileInputStream(new File(filename)));
            }
            catch (FileNotFoundException e) {
                is = null;
            }
            if (is == null) {
                is = cl.getResourceAsStream(filename);
            }
        }
        if (is == null) {
            is = cl.getResourceAsStream(defaultResource);
        }
        return is;
    }

    public static void copy(File src, File dst) {
        try {
            FileUtils.copyCheckedEx(src, dst);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyCheckedEx(File src, File dst) throws IOException {
        try (FileInputStream in = new FileInputStream(src);){
            FileUtils.copy(in, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, File dst) throws IOException {
        try {
            if (!dst.exists()) {
                dst.createNewFile();
            }
            try (FileOutputStream out = new FileOutputStream(dst);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
        }
        finally {
            in.close();
        }
    }

    public static boolean deleteFile(String filePath) {
        return FileUtils.delete(new File(filePath), false);
    }

    public static boolean deleteDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        if (directory.isDirectory() && directory.listFiles().length == 0) {
            return FileUtils.delete(directory, true);
        }
        return false;
    }

    public static boolean delete(File file, boolean recursive) {
        boolean success = true;
        if (file.isDirectory()) {
            if (recursive) {
                File[] files = file.listFiles();
                if (files == null) {
                    LOG.debug("Recursive delete failed as file was deleted outside JVM");
                    return false;
                }
                for (int i = 0; i < files.length; ++i) {
                    success = FileUtils.delete(files[i], true) && success;
                }
                boolean directoryDeleteSuccess = file.delete();
                if (!directoryDeleteSuccess) {
                    LOG.debug("Failed to delete " + file.getPath());
                }
                return success && directoryDeleteSuccess;
            }
            return false;
        }
        success = file.delete();
        if (!success) {
            LOG.debug("Failed to delete " + file.getPath());
        }
        return success;
    }

    public static void copyRecursive(File source, File dst) throws FileNotFoundException, UnableToCopyException {
        if (!source.exists()) {
            throw new FileNotFoundException("Unable to copy '" + source.toString() + "' as it does not exist.");
        }
        if (dst.exists() && !dst.isDirectory()) {
            throw new IllegalArgumentException("Unable to copy '" + source.toString() + "' to '" + String.valueOf(dst) + "' a file with same name exists.");
        }
        if (source.isFile()) {
            FileUtils.copy(source, dst);
        }
        if (!dst.isDirectory() && !dst.mkdirs()) {
            throw new UnableToCopyException("Unable to create destination directory");
        }
        for (File file : source.listFiles()) {
            if (file.isFile()) {
                FileUtils.copy(file, new File(dst.toString() + File.separator + file.getName()));
                continue;
            }
            FileUtils.copyRecursive(file, new File(String.valueOf(dst) + File.separator + file.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> searchFile(File file, String search) throws IOException {
        LinkedList<String> results = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.contains(search)) continue;
                results.add(line);
            }
        }
        return results;
    }

    public static class UnableToCopyException
    extends Exception {
        private static final long serialVersionUID = 956249157141857044L;

        UnableToCopyException(String msg) {
            super(msg);
        }
    }
}

