/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import java.io.IOException;
import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.ProtocolVersion;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class ChannelOpenOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 11;
    public static final ChannelOpenOkBody INSTANCE_0_8 = new ChannelOpenOkBody(true);
    public static final ChannelOpenOkBody INSTANCE_0_9 = new ChannelOpenOkBody(false);
    private final boolean _isAMQP08;

    public static ChannelOpenOkBody getInstance(ProtocolVersion protocolVersion, QpidByteBuffer input) throws IOException {
        ChannelOpenOkBody instance;
        boolean isAMQP08 = ProtocolVersion.v0_8.equals(protocolVersion);
        ChannelOpenOkBody channelOpenOkBody = instance = isAMQP08 ? INSTANCE_0_8 : INSTANCE_0_9;
        if (!isAMQP08) {
            EncodingUtils.readBytes(input);
        }
        return instance;
    }

    private ChannelOpenOkBody(boolean isAMQP08) {
        this._isAMQP08 = isAMQP08;
    }

    @Override
    public int getClazz() {
        return 20;
    }

    @Override
    public int getMethod() {
        return 11;
    }

    @Override
    protected int getBodySize() {
        return this._isAMQP08 ? 0 : 4;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        if (!this._isAMQP08) {
            buffer.putInt(0);
        }
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchChannelOpenOk(this, channelId);
    }

    @Override
    public String toString() {
        return "[ChannelOpenOkBody]";
    }

    public static void process(QpidByteBuffer in, ProtocolVersion protocolVersion, ClientChannelMethodProcessor dispatcher) {
        if (!ProtocolVersion.v0_8.equals(protocolVersion)) {
            EncodingUtils.readBytes(in);
        }
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveChannelOpenOk();
        }
    }
}

