/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import io.opentelemetry.api.OpenTelemetry;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationProviderList;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationService
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationService.class);
    private final String anonymousUserRole;
    private final boolean strictAuthMethod;
    private final Map<String, AuthenticationProvider> providers = new LinkedHashMap<String, AuthenticationProvider>();

    public AuthenticationService(ServiceConfiguration conf) throws PulsarServerException {
        this(conf, OpenTelemetry.noop());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthenticationService(ServiceConfiguration conf, OpenTelemetry openTelemetry) throws PulsarServerException {
        this.anonymousUserRole = conf.getAnonymousUserRole();
        this.strictAuthMethod = conf.isStrictAuthMethod();
        if (conf.isAuthenticationEnabled()) {
            try {
                LinkedHashMap<String, ArrayList<AuthenticationProvider>> providerMap = new LinkedHashMap<String, ArrayList<AuthenticationProvider>>();
                for (String className : conf.getAuthenticationProviders()) {
                    if (className.isEmpty()) continue;
                    AuthenticationProvider provider = (AuthenticationProvider)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ArrayList<AuthenticationProvider> providerList = (ArrayList<AuthenticationProvider>)providerMap.get(provider.getAuthMethodName());
                    if (null == providerList) {
                        providerList = new ArrayList<AuthenticationProvider>(1);
                        providerMap.put(provider.getAuthMethodName(), providerList);
                    }
                    providerList.add(provider);
                }
                AuthenticationProvider.Context authenticationProviderContext = AuthenticationProvider.Context.builder().config(conf).openTelemetry(openTelemetry).build();
                for (Map.Entry entry : providerMap.entrySet()) {
                    AuthenticationProvider provider = ((List)entry.getValue()).size() == 1 ? (AuthenticationProvider)((List)entry.getValue()).get(0) : new AuthenticationProviderList((List)entry.getValue());
                    provider.initialize(authenticationProviderContext);
                    this.providers.put(provider.getAuthMethodName(), provider);
                    LOG.info("[{}] has been loaded.", (Object)((List)entry.getValue()).stream().map(p -> p.getClass().getName()).collect(Collectors.joining(",")));
                }
                if (!this.providers.isEmpty()) return;
                LOG.warn("No authentication providers are loaded.");
                return;
            }
            catch (Throwable e) {
                throw new PulsarServerException("Failed to load an authentication provider.", e);
            }
        } else {
            LOG.info("Authentication is disabled");
        }
    }

    private String getAuthMethodName(HttpServletRequest request) {
        return request.getHeader("X-Pulsar-Auth-Method-Name");
    }

    private AuthenticationProvider getAuthProvider(String authMethodName) throws AuthenticationException {
        AuthenticationProvider providerToUse = this.providers.get(authMethodName);
        if (providerToUse == null) {
            throw new AuthenticationException(String.format("Unsupported authentication method: [%s].", authMethodName));
        }
        return providerToUse;
    }

    public boolean authenticateHttpRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String authMethodName = this.getAuthMethodName(request);
        if (authMethodName == null && "Kerberos".equalsIgnoreCase(request.getHeader("SASL-Type"))) {
            authMethodName = "sasl";
        }
        if (authMethodName != null) {
            AuthenticationProvider providerToUse = this.getAuthProvider(authMethodName);
            try {
                return providerToUse.authenticateHttpRequest(request, response);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed for provider " + providerToUse.getAuthMethodName() + " : " + e.getMessage(), (Throwable)e);
                }
                throw e;
            }
        }
        if (this.strictAuthMethod) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No authentication method provided while one was is required");
            }
            throw new AuthenticationException("Authentication method missing");
        }
        for (AuthenticationProvider provider : this.providers.values()) {
            try {
                return provider.authenticateHttpRequest(request, response);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Authentication failed for provider " + provider.getAuthMethodName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.providers.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)this.anonymousUserRole)) {
                request.setAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName, (Object)this.anonymousUserRole);
                request.setAttribute(AuthenticationFilter.AuthenticatedDataAttributeName, (Object)new AuthenticationDataHttps(request));
                return true;
            }
            throw new AuthenticationException("Authentication required");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated(since="3.0.0")
    public String authenticateHttpRequest(HttpServletRequest request, AuthenticationDataSource authData) throws AuthenticationException {
        authMethodName = this.getAuthMethodName(request);
        if (authMethodName != null) {
            providerToUse = this.getAuthProvider(authMethodName);
            try {
                if (authData == null) {
                    authenticationState = providerToUse.newHttpAuthState(request);
                    authData = authenticationState.getAuthDataSource();
                }
                return providerToUse.authenticateAsync(authData).get();
            }
            catch (Exception e) {
                if (!AuthenticationService.LOG.isDebugEnabled()) ** GOTO lbl21
                AuthenticationService.LOG.debug("Authentication failed for provider " + providerToUse.getAuthMethodName() + " : " + e.getMessage(), (Throwable)e);
            }
        } else {
            for (AuthenticationProvider provider : this.providers.values()) {
                try {
                    authenticationState = provider.newHttpAuthState(request);
                    return provider.authenticateAsync(authenticationState.getAuthDataSource()).get();
                }
                catch (Exception e) {
                    if (!AuthenticationService.LOG.isDebugEnabled()) continue;
                    AuthenticationService.LOG.debug("Authentication failed for provider " + provider.getAuthMethodName() + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
lbl21:
        // 3 sources

        if (!this.providers.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)this.anonymousUserRole)) {
                return this.anonymousUserRole;
            }
            throw new AuthenticationException("Authentication required");
        }
        return "<none>";
    }

    @Deprecated
    public String authenticateHttpRequest(HttpServletRequest request) throws AuthenticationException {
        return this.authenticateHttpRequest(request, (AuthenticationDataSource)null);
    }

    public AuthenticationProvider getAuthenticationProvider(String authMethodName) {
        return this.providers.get(authMethodName);
    }

    public Optional<String> getAnonymousUserRole() {
        if (StringUtils.isNotBlank((CharSequence)this.anonymousUserRole)) {
            return Optional.of(this.anonymousUserRole);
        }
        return Optional.empty();
    }

    @Override
    public void close() throws IOException {
        for (AuthenticationProvider provider : this.providers.values()) {
            provider.close();
        }
    }
}

