/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TokenRequest contains parameters of a service account token.")
public class StorageV1TokenRequest {
    public static final String SERIALIZED_NAME_AUDIENCE = "audience";
    @SerializedName(value="audience")
    private String audience;
    public static final String SERIALIZED_NAME_EXPIRATION_SECONDS = "expirationSeconds";
    @SerializedName(value="expirationSeconds")
    private Long expirationSeconds;

    public StorageV1TokenRequest audience(String audience) {
        this.audience = audience;
        return this;
    }

    @ApiModelProperty(required=true, value="Audience is the intended audience of the token in \"TokenRequestSpec\". It will default to the audiences of kube apiserver.")
    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public StorageV1TokenRequest expirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExpirationSeconds is the duration of validity of the token in \"TokenRequestSpec\". It has the same default value of \"ExpirationSeconds\" in \"TokenRequestSpec\".")
    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageV1TokenRequest storageV1TokenRequest = (StorageV1TokenRequest)o;
        return Objects.equals(this.audience, storageV1TokenRequest.audience) && Objects.equals(this.expirationSeconds, storageV1TokenRequest.expirationSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.expirationSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageV1TokenRequest {\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    expirationSeconds: ").append(this.toIndentedString(this.expirationSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

