/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.grpc;

import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.grpc.WriteStreamWrapper;
import io.oxia.proto.OxiaClientGrpc;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class OxiaWriteStreamManager {
    private final Map<Long, WriteStreamWrapper> writeStreams;
    private final OxiaStubProvider provider;
    private static final Metadata.Key<String> NAMESPACE_KEY = Metadata.Key.of((String)"namespace", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SHARD_ID_KEY = Metadata.Key.of((String)"shard-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public OxiaWriteStreamManager(OxiaStubProvider provider) {
        this.provider = provider;
        this.writeStreams = new ConcurrentHashMap<Long, WriteStreamWrapper>();
    }

    public WriteStreamWrapper getWriteStream(long shardId) {
        WriteStreamWrapper wrapper = null;
        for (int i = 0; i < 2; ++i) {
            wrapper = this.writeStreams.get(shardId);
            if (wrapper == null) {
                wrapper = this.writeStreams.computeIfAbsent(shardId, __ -> {
                    Metadata headers = new Metadata();
                    headers.put(NAMESPACE_KEY, (Object)this.provider.getNamespace());
                    headers.put(SHARD_ID_KEY, (Object)String.format("%d", shardId));
                    OxiaClientGrpc.OxiaClientStub asyncStub = this.provider.getStubForShard(shardId).async();
                    return new WriteStreamWrapper((OxiaClientGrpc.OxiaClientStub)asyncStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)headers)}));
                });
            }
            if (wrapper.isValid()) break;
            this.writeStreams.remove(shardId, wrapper);
        }
        return wrapper;
    }
}

