/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.grpc.stats;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import org.apache.bookkeeper.common.grpc.stats.ServerStats;
import org.apache.bookkeeper.common.util.MathUtils;

class MonitoringServerCall<ReqT, RespT>
extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
    private final ServerStats stats;
    private final long startNanos;

    MonitoringServerCall(ServerCall<ReqT, RespT> delegate, ServerStats stats) {
        super(delegate);
        this.stats = stats;
        this.startNanos = MathUtils.nowInNano();
        stats.recordCallStarted();
    }

    public void sendMessage(RespT message) {
        this.stats.recordStreamMessageSent();
        super.sendMessage(message);
    }

    public void close(Status status, Metadata trailers) {
        this.stats.recordServerHandled(status.getCode());
        if (this.stats.shouldRecordLatency()) {
            long latencyMicros = MathUtils.elapsedMicroSec((long)this.startNanos);
            this.stats.recordLatency(Status.OK == status, latencyMicros);
        }
        super.close(status, trailers);
    }
}

