/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.TopicBundleAssignmentStrategy;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;

public class ConsistentHashingTopicBundleAssigner
implements TopicBundleAssignmentStrategy {
    @Override
    public NamespaceBundle findBundle(TopicName topicName, NamespaceBundles namespaceBundles) {
        long hashCode = Hashing.crc32().hashString((CharSequence)topicName.toString(), StandardCharsets.UTF_8).padToLong();
        NamespaceBundle bundle = namespaceBundles.getBundle(hashCode);
        if (topicName.getDomain().equals((Object)TopicDomain.non_persistent)) {
            bundle.setHasNonPersistentTopic(true);
        }
        return bundle;
    }

    @Override
    public void init(PulsarService pulsarService) {
    }
}

