/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import picocli.CommandLine;

public class PulsarVersionStarter {
    public static void main(String[] args) {
        Arguments arguments = new Arguments();
        CommandLine commander = new CommandLine((Object)arguments);
        try {
            commander.parseArgs(args);
            if (arguments.help) {
                commander.usage(commander.getOut());
                return;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("version", (Object)commander);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            commander.getErr().println(e);
            return;
        }
        System.out.println("Current version of pulsar is: " + PulsarVersion.getVersion());
        System.out.println("Git Revision " + PulsarVersion.getGitSha());
        System.out.println("Git Branch " + PulsarVersion.getGitBranch());
        System.out.println("Built by " + PulsarVersion.getBuildUser() + " on " + PulsarVersion.getBuildHost() + " at " + PulsarVersion.getBuildTime());
    }

    @CommandLine.Command(name="version", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
    private static class Arguments {
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

