/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.common.util.FutureUtil;

public class Futures {
    public static final CompletableFuture<Void> NULL_PROMISE = CompletableFuture.completedFuture(null);

    public static CompletableFuture<Void> waitForAll(List<CompletableFuture<Void>> futures) {
        CompletableFuture<Void> compositeFuture = new CompletableFuture<Void>();
        AtomicInteger count = new AtomicInteger(futures.size());
        for (CompletableFuture<Void> future : futures) {
            future.whenComplete((r, ex) -> {
                if (ex != null) {
                    compositeFuture.completeExceptionally((Throwable)ex);
                } else if (count.decrementAndGet() == 0) {
                    compositeFuture.complete(null);
                }
            });
        }
        if (futures.isEmpty()) {
            compositeFuture.complete(null);
        }
        return compositeFuture;
    }

    public static <T> CompletableFuture<T> executeWithRetry(Supplier<CompletableFuture<T>> op, Class<? extends Exception> needRetryExceptionClass, int maxRetryTimes) {
        CompletableFuture resultFuture = new CompletableFuture();
        op.get().whenComplete((res, ex) -> {
            if (ex == null) {
                resultFuture.complete(res);
            } else {
                Throwable throwable = FutureUtil.unwrapCompletionException((Throwable)ex);
                if (needRetryExceptionClass.isAssignableFrom(throwable.getClass()) && maxRetryTimes > 0) {
                    Futures.executeWithRetry(op, needRetryExceptionClass, maxRetryTimes - 1).whenComplete((res2, ex2) -> {
                        if (ex2 == null) {
                            resultFuture.complete(res2);
                        } else {
                            resultFuture.completeExceptionally((Throwable)ex2);
                        }
                    });
                    return;
                }
                resultFuture.completeExceptionally((Throwable)ex);
            }
        });
        return resultFuture;
    }

    public static class CloseFuture
    extends CompletableFuture<Void>
    implements AsyncCallbacks.CloseCallback {
        @Override
        public void closeComplete(Object ctx) {
            this.complete(null);
        }

        @Override
        public void closeFailed(ManagedLedgerException exception, Object ctx) {
            this.completeExceptionally(exception);
        }
    }
}

