/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnExitCodesRequirement;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnPodConditionsPattern;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodFailurePolicyRule describes how a pod failure is handled when the requirements are met. One of OnExitCodes and onPodConditions, but not both, can be used in each rule.")
public class V1PodFailurePolicyRule {
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private String action;
    public static final String SERIALIZED_NAME_ON_EXIT_CODES = "onExitCodes";
    @SerializedName(value="onExitCodes")
    private V1PodFailurePolicyOnExitCodesRequirement onExitCodes;
    public static final String SERIALIZED_NAME_ON_POD_CONDITIONS = "onPodConditions";
    @SerializedName(value="onPodConditions")
    private List<V1PodFailurePolicyOnPodConditionsPattern> onPodConditions = new ArrayList<V1PodFailurePolicyOnPodConditionsPattern>();

    public V1PodFailurePolicyRule action(String action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the action taken on a pod failure when the requirements are satisfied. Possible values are: - FailJob: indicates that the pod's job is marked as Failed and all   running pods are terminated. - Ignore: indicates that the counter towards the .backoffLimit is not   incremented and a replacement pod is created. - Count: indicates that the pod is handled in the default way - the   counter towards the .backoffLimit is incremented. Additional values are considered to be added in the future. Clients should react to an unknown action by skipping the rule.  ")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public V1PodFailurePolicyRule onExitCodes(V1PodFailurePolicyOnExitCodesRequirement onExitCodes) {
        this.onExitCodes = onExitCodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodFailurePolicyOnExitCodesRequirement getOnExitCodes() {
        return this.onExitCodes;
    }

    public void setOnExitCodes(V1PodFailurePolicyOnExitCodesRequirement onExitCodes) {
        this.onExitCodes = onExitCodes;
    }

    public V1PodFailurePolicyRule onPodConditions(List<V1PodFailurePolicyOnPodConditionsPattern> onPodConditions) {
        this.onPodConditions = onPodConditions;
        return this;
    }

    public V1PodFailurePolicyRule addOnPodConditionsItem(V1PodFailurePolicyOnPodConditionsPattern onPodConditionsItem) {
        this.onPodConditions.add(onPodConditionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Represents the requirement on the pod conditions. The requirement is represented as a list of pod condition patterns. The requirement is satisfied if at least one pattern matches an actual pod condition. At most 20 elements are allowed.")
    public List<V1PodFailurePolicyOnPodConditionsPattern> getOnPodConditions() {
        return this.onPodConditions;
    }

    public void setOnPodConditions(List<V1PodFailurePolicyOnPodConditionsPattern> onPodConditions) {
        this.onPodConditions = onPodConditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodFailurePolicyRule v1PodFailurePolicyRule = (V1PodFailurePolicyRule)o;
        return Objects.equals(this.action, v1PodFailurePolicyRule.action) && Objects.equals(this.onExitCodes, v1PodFailurePolicyRule.onExitCodes) && Objects.equals(this.onPodConditions, v1PodFailurePolicyRule.onPodConditions);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.onExitCodes, this.onPodConditions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodFailurePolicyRule {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    onExitCodes: ").append(this.toIndentedString(this.onExitCodes)).append("\n");
        sb.append("    onPodConditions: ").append(this.toIndentedString(this.onPodConditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

