/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.bookkeeper.mledger.ManagedLedgerInfo;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheManager;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface ManagedLedgerFactory {
    public ManagedLedger open(String var1) throws InterruptedException, ManagedLedgerException;

    public ManagedLedger open(String var1, ManagedLedgerConfig var2) throws InterruptedException, ManagedLedgerException;

    public void asyncOpen(String var1, AsyncCallbacks.OpenLedgerCallback var2, Object var3);

    public void asyncOpen(String var1, ManagedLedgerConfig var2, AsyncCallbacks.OpenLedgerCallback var3, Supplier<CompletableFuture<Boolean>> var4, Object var5);

    public ReadOnlyCursor openReadOnlyCursor(String var1, Position var2, ManagedLedgerConfig var3) throws InterruptedException, ManagedLedgerException;

    public void asyncOpenReadOnlyCursor(String var1, Position var2, ManagedLedgerConfig var3, AsyncCallbacks.OpenReadOnlyCursorCallback var4, Object var5);

    public void asyncOpenReadOnlyManagedLedger(String var1, AsyncCallbacks.OpenReadOnlyManagedLedgerCallback var2, ManagedLedgerConfig var3, Object var4);

    public ManagedLedgerInfo getManagedLedgerInfo(String var1) throws InterruptedException, ManagedLedgerException;

    public void asyncGetManagedLedgerInfo(String var1, AsyncCallbacks.ManagedLedgerInfoCallback var2, Object var3);

    public void delete(String var1) throws InterruptedException, ManagedLedgerException;

    public void delete(String var1, CompletableFuture<ManagedLedgerConfig> var2) throws InterruptedException, ManagedLedgerException;

    public void asyncDelete(String var1, AsyncCallbacks.DeleteLedgerCallback var2, Object var3);

    public void asyncDelete(String var1, CompletableFuture<ManagedLedgerConfig> var2, AsyncCallbacks.DeleteLedgerCallback var3, Object var4);

    public void shutdown() throws InterruptedException, ManagedLedgerException;

    public CompletableFuture<Void> shutdownAsync() throws ManagedLedgerException, InterruptedException;

    public CompletableFuture<Boolean> asyncExists(String var1);

    public EntryCacheManager getEntryCacheManager();

    public void updateCacheEvictionTimeThreshold(long var1);

    public long getCacheEvictionTimeThreshold();

    public CompletableFuture<Map<String, String>> getManagedLedgerPropertiesAsync(String var1);

    public Map<String, ManagedLedger> getManagedLedgers();

    public ManagedLedgerFactoryMXBean getCacheStats();

    public void estimateUnloadedTopicBacklog(PersistentOfflineTopicStats var1, TopicName var2, boolean var3, Object var4) throws Exception;

    public ManagedLedgerFactoryConfig getConfig();
}

