/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.asynchttpclient.request.body.RandomAccessBody;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.MiscUtils;

class BodyFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private final RandomAccessBody body;
    private long transferred;

    BodyFileRegion(RandomAccessBody body) {
        this.body = Assertions.assertNotNull(body, "body");
    }

    public long position() {
        return 0L;
    }

    public long count() {
        return this.body.getContentLength();
    }

    public long transfered() {
        return this.transferred();
    }

    public long transferred() {
        return this.transferred;
    }

    public FileRegion retain() {
        super.retain();
        return this;
    }

    public FileRegion retain(int arg0) {
        super.retain(arg0);
        return this;
    }

    public FileRegion touch() {
        return this;
    }

    public FileRegion touch(Object arg0) {
        return this;
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long written = this.body.transferTo(target);
        if (written > 0L) {
            this.transferred += written;
        }
        return written;
    }

    protected void deallocate() {
        MiscUtils.closeSilently(this.body);
    }
}

