/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.MemoryMappedFile;
import com.yahoo.memory.MemoryRequest;
import com.yahoo.memory.NativeMemory;
import com.yahoo.memory.UnsafeUtil;

public class AllocMemory
extends MemoryMappedFile {
    public AllocMemory(long capacityBytes) {
        super(0L, null, null);
        this.nativeRawStartAddress_ = UnsafeUtil.unsafe.allocateMemory(capacityBytes);
        this.capacityBytes_ = capacityBytes;
        this.memReq_ = null;
    }

    public AllocMemory(long capacityBytes, MemoryRequest memReq) {
        super(0L, null, null);
        this.nativeRawStartAddress_ = UnsafeUtil.unsafe.allocateMemory(capacityBytes);
        this.capacityBytes_ = capacityBytes;
        this.memReq_ = memReq;
    }

    public AllocMemory(NativeMemory origMem, long newCapacityBytes, MemoryRequest memReq) {
        super(0L, null, null);
        this.nativeRawStartAddress_ = UnsafeUtil.unsafe.reallocateMemory(origMem.nativeRawStartAddress_, newCapacityBytes);
        this.capacityBytes_ = newCapacityBytes;
        this.memReq_ = memReq;
        origMem.nativeRawStartAddress_ = 0L;
        origMem.capacityBytes_ = 0L;
    }

    public AllocMemory(NativeMemory origMem, long copyToBytes, long capacityBytes, MemoryRequest memReq) {
        super(0L, null, null);
        this.nativeRawStartAddress_ = UnsafeUtil.unsafe.allocateMemory(capacityBytes);
        this.capacityBytes_ = capacityBytes;
        this.memReq_ = memReq;
        NativeMemory.copy(origMem, 0L, this, 0L, copyToBytes);
        this.clear(copyToBytes, capacityBytes - copyToBytes);
    }

    @Override
    public void freeMemory() {
        super.freeMemory();
    }
}

