/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLRUCache<K extends Comparable, V>
extends ConcurrentHashMap<K, V> {
    protected static final Logger LOG = LoggerFactory.getLogger(SimpleLRUCache.class);
    int maxSize;
    int triggerSize;
    private ConcurrentHashMap<K, AtomicLong> accessed = new ConcurrentHashMap();

    public SimpleLRUCache(long maxSize, int concurrencyLevel) {
        super((int)((double)maxSize * 1.1), 0.75f, concurrencyLevel);
        this.maxSize = (int)maxSize;
        this.triggerSize = (int)((double)maxSize * 1.1) + 1;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V value = super.computeIfAbsent(key, mappingFunction);
        if (value != null) {
            this.accessed.put(key, new AtomicLong(System.currentTimeMillis()));
            if (this.size() > this.triggerSize) {
                this.evict();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict() {
        SimpleLRUCache simpleLRUCache = this;
        synchronized (simpleLRUCache) {
            int currentSize = this.size();
            if (currentSize <= this.triggerSize) {
                return;
            }
            LOG.warn("UGI Cache capacity exceeded, you may want to increase its size");
            TreeSet<Map.Entry<K, AtomicLong>> sortedByLRU = new TreeSet<Map.Entry<K, AtomicLong>>(new Comparator<Map.Entry<K, AtomicLong>>(){

                @Override
                public int compare(Map.Entry<K, AtomicLong> o1, Map.Entry<K, AtomicLong> o2) {
                    int keyResult = Long.compare(o2.getValue().get(), o1.getValue().get());
                    if (keyResult == 0) {
                        return ((Comparable)o2.getKey()).compareTo(o1.getKey());
                    }
                    return keyResult;
                }
            });
            sortedByLRU.addAll(this.accessed.entrySet());
            Map.Entry[] toRetain = Arrays.copyOfRange(sortedByLRU.toArray(new Map.Entry[currentSize]), 0, this.maxSize);
            List retainList = Arrays.stream(toRetain).map(f -> f.getKey()).collect(Collectors.toList());
            ((ConcurrentHashMap.CollectionView)((Object)this.keySet())).retainAll(retainList);
            ((ConcurrentHashMap.CollectionView)((Object)this.accessed.keySet())).retainAll(this.keySet());
        }
    }
}

