/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.index;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.CompositeIndicesRequest;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.RoutingMissingException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.client.Requests;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.UUIDs;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.VersionType;
import org.opensearch.index.shard.ShardId;

public class IndexRequest
extends ReplicatedWriteRequest<IndexRequest>
implements DocWriteRequest<IndexRequest>,
CompositeIndicesRequest {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(IndexRequest.class);
    static final int MAX_SOURCE_LENGTH_IN_TOSTRING = 2048;
    private static final ShardId NO_SHARD_ID = null;
    private String type;
    private String id;
    @Nullable
    private String routing;
    private BytesReference source;
    private DocWriteRequest.OpType opType = DocWriteRequest.OpType.INDEX;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private XContentType contentType;
    private String pipeline;
    private String finalPipeline;
    private boolean isPipelineResolved;
    private boolean requireAlias;
    public static final long UNSET_AUTO_GENERATED_TIMESTAMP = -1L;
    private long autoGeneratedTimestamp = -1L;
    private boolean isRetry = false;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;

    public IndexRequest(StreamInput in) throws IOException {
        this(null, in);
    }

    public IndexRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        this.type = in.readOptionalString();
        this.id = in.readOptionalString();
        this.routing = in.readOptionalString();
        if (in.getVersion().before(LegacyESVersion.V_7_0_0)) {
            in.readOptionalString();
        }
        if (in.getVersion().before(LegacyESVersion.V_6_0_0_alpha1)) {
            in.readOptionalString();
            in.readOptionalTimeValue();
        }
        this.source = in.readBytesReference();
        this.opType = DocWriteRequest.OpType.fromId(in.readByte());
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        this.pipeline = in.readOptionalString();
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_5_0)) {
            this.finalPipeline = in.readOptionalString();
        }
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_5_0)) {
            this.isPipelineResolved = in.readBoolean();
        }
        this.isRetry = in.readBoolean();
        this.autoGeneratedTimestamp = in.readLong();
        this.contentType = in.readBoolean() ? in.readEnum(XContentType.class) : null;
        if (in.getVersion().onOrAfter(LegacyESVersion.V_6_6_0)) {
            this.ifSeqNo = in.readZLong();
            this.ifPrimaryTerm = in.readVLong();
        } else {
            this.ifSeqNo = -2L;
            this.ifPrimaryTerm = 0L;
        }
        this.requireAlias = in.getVersion().onOrAfter(LegacyESVersion.V_7_10_0) ? in.readBoolean() : false;
    }

    public IndexRequest() {
        super(NO_SHARD_ID);
    }

    public IndexRequest(String index) {
        super(NO_SHARD_ID);
        this.index = index;
    }

    @Deprecated
    public IndexRequest(String index, String type) {
        super(NO_SHARD_ID);
        this.index = index;
        this.type = type;
    }

    @Deprecated
    public IndexRequest(String index, String type, String id) {
        super(NO_SHARD_ID);
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        if (Strings.isEmpty(this.type())) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.contentType == null) {
            validationException = ValidateActions.addValidationError("content type is missing", validationException);
        }
        assert (this.opType == DocWriteRequest.OpType.INDEX || this.opType == DocWriteRequest.OpType.CREATE) : "unexpected op-type: " + (Object)((Object)this.opType);
        long resolvedVersion = this.resolveVersionDefaults();
        if (this.opType == DocWriteRequest.OpType.CREATE) {
            if (this.versionType != VersionType.INTERNAL) {
                validationException = ValidateActions.addValidationError("create operations only support internal versioning. use index instead", validationException);
                return validationException;
            }
            if (resolvedVersion != -4L) {
                validationException = ValidateActions.addValidationError("create operations do not support explicit versions. use index instead", validationException);
                return validationException;
            }
            if (this.ifSeqNo != -2L || this.ifPrimaryTerm != 0L) {
                validationException = ValidateActions.addValidationError("create operations do not support compare and set. use index instead", validationException);
                return validationException;
            }
        }
        if (this.id == null && (this.versionType != VersionType.INTERNAL || resolvedVersion != -4L && resolvedVersion != -3L)) {
            validationException = ValidateActions.addValidationError("an id must be provided if version type or value are set", validationException);
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams(this, validationException);
        if (this.id != null && this.id.getBytes(StandardCharsets.UTF_8).length > 512) {
            validationException = ValidateActions.addValidationError("id [" + this.id + "] is too long, must be no longer than 512 bytes but was: " + this.id.getBytes(StandardCharsets.UTF_8).length, validationException);
        }
        if (this.pipeline != null && this.pipeline.isEmpty()) {
            validationException = ValidateActions.addValidationError("pipeline cannot be an empty string", validationException);
        }
        if (this.finalPipeline != null && this.finalPipeline.isEmpty()) {
            validationException = ValidateActions.addValidationError("final pipeline cannot be an empty string", validationException);
        }
        return validationException;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public XContentType getContentType() {
        return this.contentType;
    }

    @Override
    @Deprecated
    public String type() {
        if (this.type == null) {
            return "_doc";
        }
        return this.type;
    }

    @Override
    @Deprecated
    public IndexRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Deprecated
    public IndexRequest defaultTypeIfNull(String defaultType) {
        if (Strings.isNullOrEmpty(this.type)) {
            this.type = defaultType;
        }
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public IndexRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public IndexRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    public IndexRequest setPipeline(String pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public IndexRequest setFinalPipeline(String finalPipeline) {
        this.finalPipeline = finalPipeline;
        return this;
    }

    public String getFinalPipeline() {
        return this.finalPipeline;
    }

    public IndexRequest isPipelineResolved(boolean isPipelineResolved) {
        this.isPipelineResolved = isPipelineResolved;
        return this;
    }

    public boolean isPipelineResolved() {
        return this.isPipelineResolved;
    }

    public BytesReference source() {
        return this.source;
    }

    public Map<String, Object> sourceAsMap() {
        return (Map)XContentHelper.convertToMap(this.source, false, this.contentType).v2();
    }

    public IndexRequest source(Map<String, ?> source) throws OpenSearchGenerationException {
        return this.source(source, Requests.INDEX_CONTENT_TYPE);
    }

    public IndexRequest source(Map<String, ?> source, XContentType contentType) throws OpenSearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public IndexRequest source(String source, XContentType xContentType) {
        return this.source(new BytesArray(source), xContentType);
    }

    public IndexRequest source(XContentBuilder sourceBuilder) {
        return this.source(BytesReference.bytes(sourceBuilder), sourceBuilder.contentType());
    }

    public IndexRequest source(Object ... source) {
        return this.source(Requests.INDEX_CONTENT_TYPE, source);
    }

    public IndexRequest source(XContentType xContentType, Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("The number of object passed must be even but was [" + source.length + "]");
        }
        if (source.length == 2 && source[0] instanceof BytesReference && source[1] instanceof Boolean) {
            throw new IllegalArgumentException("you are using the removed method for source with bytes and unsafe flag, the unsafe flag was removed, please just use source(BytesReference)");
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);
            builder.startObject();
            for (int i = 0; i < source.length; ++i) {
                builder.field(source[i++].toString(), source[i]);
            }
            builder.endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequest source(BytesReference source, XContentType xContentType) {
        this.source = Objects.requireNonNull(source);
        this.contentType = Objects.requireNonNull(xContentType);
        return this;
    }

    public IndexRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public IndexRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public IndexRequest opType(DocWriteRequest.OpType opType) {
        if (opType != DocWriteRequest.OpType.CREATE && opType != DocWriteRequest.OpType.INDEX) {
            throw new IllegalArgumentException("opType must be 'create' or 'index', found: [" + (Object)((Object)opType) + "]");
        }
        this.opType = opType;
        return this;
    }

    public IndexRequest opType(String opType) {
        String op = opType.toLowerCase(Locale.ROOT);
        if (op.equals("create")) {
            this.opType(DocWriteRequest.OpType.CREATE);
        } else if (op.equals("index")) {
            this.opType(DocWriteRequest.OpType.INDEX);
        } else {
            throw new IllegalArgumentException("opType must be 'create' or 'index', found: [" + opType + "]");
        }
        return this;
    }

    public IndexRequest create(boolean create) {
        if (create) {
            return this.opType(DocWriteRequest.OpType.CREATE);
        }
        return this.opType(DocWriteRequest.OpType.INDEX);
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return this.opType;
    }

    @Override
    public IndexRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.resolveVersionDefaults();
    }

    private long resolveVersionDefaults() {
        if (this.opType == DocWriteRequest.OpType.CREATE && this.version == -3L) {
            return -4L;
        }
        return this.version;
    }

    @Override
    public IndexRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public IndexRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    @Override
    public IndexRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    @Override
    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Override
    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    public void process(Version indexCreatedVersion, @Nullable MappingMetadata mappingMd, String concreteIndex) {
        if (mappingMd != null && mappingMd.routing().required() && this.routing == null) {
            throw new RoutingMissingException(concreteIndex, this.type(), this.id);
        }
        if ("".equals(this.id)) {
            throw new IllegalArgumentException("if _id is specified it must not be empty");
        }
        if (this.id == null) {
            assert (this.autoGeneratedTimestamp == -1L) : "timestamp has already been generated!";
            assert (this.ifSeqNo == -2L);
            assert (this.ifPrimaryTerm == 0L);
            this.autoGeneratedTimestamp = Math.max(0L, System.currentTimeMillis());
            String uid = indexCreatedVersion.onOrAfter(LegacyESVersion.V_6_0_0_beta1) ? UUIDs.base64UUID() : UUIDs.legacyBase64UUID();
            this.id(uid);
        }
    }

    public void resolveRouting(Metadata metadata) {
        this.routing(metadata.resolveWriteIndexRouting(this.routing, this.index));
    }

    public void checkAutoIdWithOpTypeCreateSupportedByVersion(Version version) {
        if (this.id == null && this.opType == DocWriteRequest.OpType.CREATE && version.before(LegacyESVersion.V_7_5_0)) {
            throw new IllegalArgumentException("optype create not supported for indexing requests without explicit id until all nodes are on version 7.5.0 or higher");
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.checkAutoIdWithOpTypeCreateSupportedByVersion(out.getVersion());
        super.writeTo(out);
        this.writeBody(out);
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        this.checkAutoIdWithOpTypeCreateSupportedByVersion(out.getVersion());
        super.writeThin(out);
        this.writeBody(out);
    }

    private void writeBody(StreamOutput out) throws IOException {
        out.writeOptionalString(this.type());
        out.writeOptionalString(this.id);
        out.writeOptionalString(this.routing);
        if (out.getVersion().before(LegacyESVersion.V_7_0_0)) {
            out.writeOptionalString(null);
        }
        if (out.getVersion().before(LegacyESVersion.V_6_0_0_alpha1)) {
            out.writeOptionalString("0");
            out.writeOptionalWriteable(null);
        }
        out.writeBytesReference(this.source);
        out.writeByte(this.opType.getId());
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        out.writeOptionalString(this.pipeline);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_5_0)) {
            out.writeOptionalString(this.finalPipeline);
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_5_0)) {
            out.writeBoolean(this.isPipelineResolved);
        }
        out.writeBoolean(this.isRetry);
        out.writeLong(this.autoGeneratedTimestamp);
        if (this.contentType != null) {
            out.writeBoolean(true);
            out.writeEnum(this.contentType);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_6_6_0)) {
            out.writeZLong(this.ifSeqNo);
            out.writeVLong(this.ifPrimaryTerm);
        } else if (this.ifSeqNo != -2L || this.ifPrimaryTerm != 0L) {
            assert (false) : "setIfMatch [" + this.ifSeqNo + "], currentDocTem [" + this.ifPrimaryTerm + "]";
            throw new IllegalStateException("sequence number based compare and write is not supported until all nodes are on version 7.0 or higher. Stream version [" + out.getVersion() + "]");
        }
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_10_0)) {
            out.writeBoolean(this.requireAlias);
        }
    }

    @Override
    public String toString() {
        String sSource = "_na_";
        try {
            sSource = this.source.length() > 2048 ? "n/a, actual length: [" + new ByteSizeValue(this.source.length()).toString() + "], max length: " + new ByteSizeValue(2048L).toString() : XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "index {[" + this.index + "][" + this.type() + "][" + this.id + "], source[" + sSource + "]}";
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    @Override
    public void onRetry() {
        this.isRetry = true;
    }

    public long getAutoGeneratedTimestamp() {
        return this.autoGeneratedTimestamp;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.id) + (long)(this.source == null ? 0 : this.source.length());
    }

    @Override
    public boolean isRequireAlias() {
        return this.requireAlias;
    }

    public IndexRequest setRequireAlias(boolean requireAlias) {
        this.requireAlias = requireAlias;
        return this;
    }
}

