/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.extension;

import crawlercommons.sitemaps.extension.ExtensionMetadata;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class PageMapDataObject
extends ExtensionMetadata {
    private String type;
    private String id;
    private Map<String, String> attributes;

    public PageMapDataObject(String type, String id) {
        this.type = type;
        this.id = id;
        this.attributes = new LinkedHashMap<String, String>();
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String addAttribute(String name, String value) {
        return this.attributes.put(name, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageMapDataObject other = (PageMapDataObject)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{type = ").append(this.type);
        sb.append(", id = ").append(this.id);
        sb.append(", attributes = ").append(this.attributes);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Map<String, String[]> asMap() {
        String keyFormat = "%s::%s";
        String valueFormat = "%s: %s";
        String key = String.format(Locale.ROOT, keyFormat, this.getType() == null ? "" : this.getType(), this.getId() == null ? "" : this.getId());
        String[] values = (String[])this.getAttributes().entrySet().stream().map(e -> String.format(Locale.ROOT, valueFormat, e.getKey(), e.getValue())).toArray(String[]::new);
        return Map.of(key, values);
    }
}

