/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.http;

import java.io.IOException;
import java.io.InputStream;
import org.archive.format.http.HttpHeaderParser;
import org.archive.format.http.HttpHeaders;
import org.archive.format.http.HttpParseException;
import org.archive.resource.MetaData;
import org.archive.resource.Resource;
import org.archive.resource.ResourceConstants;
import org.archive.resource.ResourceContainer;
import org.archive.resource.ResourceFactory;
import org.archive.resource.ResourceParseException;
import org.archive.resource.http.HTTPHeadersResource;
import org.archive.util.StreamCopy;

public class HTTPHeadersResourceFactory
implements ResourceFactory,
ResourceConstants {
    private String name;
    private String type;
    HttpHeaderParser parser;

    public HTTPHeadersResourceFactory(String name) {
        this(name, null);
    }

    public HTTPHeadersResourceFactory(String name, String type) {
        this.name = name;
        this.type = type;
        this.parser = new HttpHeaderParser();
    }

    @Override
    public Resource getResource(InputStream is, MetaData parentMetaData, ResourceContainer container) throws ResourceParseException, IOException {
        HttpHeaders headers = new HttpHeaders();
        try {
            int bytes = this.parser.doParse(is, headers);
            if (headers.isCorrupt()) {
                parentMetaData.putBoolean("Headers-Corrupt", true);
            }
            if (!parentMetaData.has("Actual-Content-Length") || (long)bytes != parentMetaData.getLong("Actual-Content-Length")) {
                parentMetaData.putLong("Actual-Content-Length", bytes);
            }
            long trailingSlopBytes = StreamCopy.readToEOF(is);
            if (!parentMetaData.has("Trailing-Slop-Length") || trailingSlopBytes > 0L) {
                parentMetaData.putLong("Trailing-Slop-Length", trailingSlopBytes);
            }
            if (this.type != null) {
                parentMetaData.putString("Actual-Content-Type", this.type);
            }
            return new HTTPHeadersResource(parentMetaData.createChild(this.name), container, headers);
        }
        catch (HttpParseException e) {
            throw new ResourceParseException(e);
        }
    }
}

