/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.Table;
import org.opensearch.common.regex.Regex;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestTemplatesAction
extends AbstractCatAction {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/templates"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/templates/{name}")));
    }

    @Override
    public String getName() {
        return "cat_templates_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/templates\n");
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        final String matchPattern = request.hasParam("name") ? request.param("name") : null;
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().metadata(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestResponseListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse clusterStateResponse) throws Exception {
                return RestTable.buildResponse(RestTemplatesAction.this.buildTable(request, clusterStateResponse, matchPattern), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("name", "alias:n;desc:template name");
        table.addCell("index_patterns", "alias:t;desc:template index patterns");
        table.addCell("order", "alias:o,p;desc:template application order/priority number");
        table.addCell("version", "alias:v;desc:version");
        table.addCell("composed_of", "alias:c;desc:component templates comprising index template");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse clusterStateResponse, String patternString) {
        Table table = this.getTableWithHeader(request);
        Metadata metadata = clusterStateResponse.getState().metadata();
        for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : metadata.templates()) {
            IndexTemplateMetadata indexData = (IndexTemplateMetadata)objectObjectCursor.value;
            if (patternString != null && !Regex.simpleMatch(patternString, indexData.name())) continue;
            table.startRow();
            table.addCell(indexData.name());
            table.addCell("[" + String.join((CharSequence)", ", indexData.patterns()) + "]");
            table.addCell(indexData.getOrder());
            table.addCell(indexData.getVersion());
            table.addCell("");
            table.endRow();
        }
        for (Map.Entry entry : metadata.templatesV2().entrySet()) {
            String name = (String)entry.getKey();
            ComposableIndexTemplate template = (ComposableIndexTemplate)entry.getValue();
            if (patternString != null && !Regex.simpleMatch(patternString, name)) continue;
            table.startRow();
            table.addCell(name);
            table.addCell("[" + String.join((CharSequence)", ", template.indexPatterns()) + "]");
            table.addCell(template.priorityOrZero());
            table.addCell(template.version());
            table.addCell("[" + String.join((CharSequence)", ", template.composedOf()) + "]");
            table.endRow();
        }
        return table;
    }
}

