/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.resources;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.nutch.service.model.request.NutchConfig;
import org.apache.nutch.service.resources.AbstractResource;

@Path(value="/config")
public class ConfigResource
extends AbstractResource {
    public static final String DEFAULT = "default";

    @GET
    @Path(value="/")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Set<String> getConfigs() {
        return this.configManager.list();
    }

    @GET
    @Path(value="/{configId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public Map<String, String> getConfig(@PathParam(value="configId") String configId) {
        return this.configManager.getAsMap(configId);
    }

    @GET
    @Path(value="/{configId}/{propertyId}")
    @Produces(value={"text/plain"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public String getProperty(@PathParam(value="configId") String configId, @PathParam(value="propertyId") String propertyId) {
        return this.configManager.getAsMap(configId).get(propertyId);
    }

    @DELETE
    @Path(value="/{configId}")
    public void deleteConfig(@PathParam(value="configId") String configId) {
        this.configManager.delete(configId);
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response createConfig(NutchConfig newConfig) {
        if (newConfig == null) {
            return Response.status((int)400).entity((Object)"Nutch configuration cannot be empty!").build();
        }
        try {
            this.configManager.create(newConfig);
        }
        catch (Exception e) {
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        return Response.ok((Object)newConfig.getConfigId()).build();
    }

    @PUT
    @Path(value="/{configId}/{propertyId}")
    @Consumes(value={"text/plain"})
    public Response updateProperty(@PathParam(value="configId") String confId, @PathParam(value="propertyId") String propertyKey, String value) {
        try {
            this.configManager.setProperty(confId, propertyKey, value);
        }
        catch (Exception e) {
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }
}

