/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.fetcher;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.NutchWritable;
import org.apache.nutch.fetcher.Fetcher;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseOutputFormat;
import org.apache.nutch.protocol.Content;

public class FetcherOutputFormat
extends FileOutputFormat<Text, NutchWritable> {
    public void checkOutputSpecs(JobContext job) throws IOException {
        Configuration conf = job.getConfiguration();
        Path out = FileOutputFormat.getOutputPath((JobContext)job);
        if (out == null && job.getNumReduceTasks() != 0) {
            throw new InvalidJobConfException("Output directory not set in conf.");
        }
        FileSystem fs = out.getFileSystem(conf);
        if (fs.exists(new Path(out, "crawl_fetch"))) {
            throw new IOException("Segment already fetched!");
        }
    }

    public RecordWriter<Text, NutchWritable> getRecordWriter(final TaskAttemptContext context) throws IOException {
        final Configuration conf = context.getConfiguration();
        String name = FetcherOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)"part", (String)"");
        Path out = FileOutputFormat.getOutputPath((JobContext)context);
        Path fetch = new Path(new Path(out, "crawl_fetch"), name);
        final Path content = new Path(new Path(out, "content"), name);
        final SequenceFile.CompressionType compType = SequenceFileOutputFormat.getOutputCompressionType((JobContext)context);
        MapFile.Writer.Option fKeyClassOpt = MapFile.Writer.keyClass(Text.class);
        SequenceFile.Writer.Option fValClassOpt = SequenceFile.Writer.valueClass(CrawlDatum.class);
        SequenceFile.Writer.Option fProgressOpt = SequenceFile.Writer.progressable((Progressable)context);
        SequenceFile.Writer.Option fCompOpt = SequenceFile.Writer.compression((SequenceFile.CompressionType)compType);
        final MapFile.Writer fetchOut = new MapFile.Writer(conf, fetch, new SequenceFile.Writer.Option[]{fKeyClassOpt, fValClassOpt, fCompOpt, fProgressOpt});
        return new RecordWriter<Text, NutchWritable>(){
            private MapFile.Writer contentOut;
            private RecordWriter<Text, Parse> parseOut;
            {
                if (Fetcher.isStoringContent(conf)) {
                    MapFile.Writer.Option cKeyClassOpt = MapFile.Writer.keyClass(Text.class);
                    SequenceFile.Writer.Option cValClassOpt = SequenceFile.Writer.valueClass(Content.class);
                    SequenceFile.Writer.Option cProgressOpt = SequenceFile.Writer.progressable((Progressable)context);
                    SequenceFile.Writer.Option cCompOpt = SequenceFile.Writer.compression((SequenceFile.CompressionType)compType);
                    this.contentOut = new MapFile.Writer(conf, content, new SequenceFile.Writer.Option[]{cKeyClassOpt, cValClassOpt, cCompOpt, cProgressOpt});
                }
                if (Fetcher.isParsing(conf)) {
                    this.parseOut = new ParseOutputFormat().getRecordWriter(context);
                }
            }

            public void write(Text key, NutchWritable value) throws IOException, InterruptedException {
                Writable w = value.get();
                if (w instanceof CrawlDatum) {
                    fetchOut.append((WritableComparable)key, w);
                } else if (w instanceof Content && this.contentOut != null) {
                    this.contentOut.append((WritableComparable)key, w);
                } else if (w instanceof Parse && this.parseOut != null) {
                    this.parseOut.write((Object)key, (Object)((Parse)w));
                }
            }

            public void close(TaskAttemptContext context2) throws IOException, InterruptedException {
                fetchOut.close();
                if (this.contentOut != null) {
                    this.contentOut.close();
                }
                if (this.parseOut != null) {
                    this.parseOut.close(context2);
                }
            }
        };
    }
}

