/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.util;

import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.server.util.timer.TimerTask;

public class SystemTimerReaper
implements Timer {
    private static final long WORK_TIMEOUT_MS = 200L;
    private final Timer timer;
    private final Reaper reaper;

    public SystemTimerReaper(String reaperThreadName, Timer timer) {
        this.timer = timer;
        this.reaper = new Reaper(reaperThreadName);
        this.reaper.start();
    }

    public void add(TimerTask timerTask) {
        this.timer.add(timerTask);
    }

    public boolean advanceClock(long timeoutMs) throws InterruptedException {
        return this.timer.advanceClock(timeoutMs);
    }

    public int size() {
        return this.timer.size();
    }

    public void close() throws Exception {
        this.reaper.initiateShutdown();
        this.timer.add(new TimerTask(0L){

            public void run() {
            }
        });
        this.reaper.awaitShutdown();
        this.timer.close();
    }

    class Reaper
    extends ShutdownableThread {
        Reaper(String name) {
            super(name, false);
        }

        public void doWork() {
            try {
                SystemTimerReaper.this.timer.advanceClock(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

