/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.util.Assert;

abstract class AbstractSecurityAnnotationScanner<A extends Annotation>
implements SecurityAnnotationScanner<A> {
    AbstractSecurityAnnotationScanner() {
    }

    @Override
    public @Nullable A scan(Method method, Class<?> targetClass) {
        Assert.notNull(targetClass, (String)"targetClass cannot be null");
        MergedAnnotation<A> annotation = this.merge(method, targetClass);
        if (annotation == null) {
            return null;
        }
        return (A)annotation.synthesize();
    }

    @Override
    public @Nullable A scan(Parameter parameter) {
        MergedAnnotation<A> annotation = this.merge(parameter, null);
        if (annotation == null) {
            return null;
        }
        return (A)annotation.synthesize();
    }

    abstract @Nullable MergedAnnotation<A> merge(AnnotatedElement var1, @Nullable Class<?> var2);
}

