/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data;

import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.data.ConditionalOnRepositoryType;
import org.springframework.boot.autoconfigure.data.RepositoryType;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

class OnRepositoryTypeCondition
extends SpringBootCondition {
    OnRepositoryTypeCondition() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        @Nullable Map attributes = metadata.getAnnotationAttributes(ConditionalOnRepositoryType.class.getName(), true);
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"'attributes' must not be null");
        String store = (String)attributes.get("store");
        Assert.state((store != null ? 1 : 0) != 0, (String)"'store' must not be null");
        RepositoryType configuredType = this.getTypeProperty(context.getEnvironment(), store);
        RepositoryType requiredType = (RepositoryType)((Object)attributes.get("type"));
        Assert.state((requiredType != null ? 1 : 0) != 0, (String)"'requiredType' must not be null");
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnRepositoryType.class, new Object[0]);
        if (configuredType == requiredType || configuredType == RepositoryType.AUTO) {
            return ConditionOutcome.match(message.because("configured type of '" + configuredType.name() + "' matched required type"));
        }
        return ConditionOutcome.noMatch(message.because("configured type (" + configuredType.name() + ") did not match required type (" + requiredType.name() + ")"));
    }

    private RepositoryType getTypeProperty(Environment environment, String store) {
        return RepositoryType.valueOf(environment.getProperty(String.format("spring.data.%s.repositories.type", store), "auto").toUpperCase(Locale.ENGLISH));
    }
}

