/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.ObservationAuthorizationManager;
import org.springframework.security.config.http.GrantedAuthorityDefaultsParserUtils;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.web.access.expression.DefaultHttpSecurityExpressionHandler;
import org.springframework.security.web.access.expression.WebExpressionAuthorizationManager;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.access.intercept.RequestMatcherDelegatingAuthorizationManager;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class AuthorizationFilterParser
implements BeanDefinitionParser {
    private static final String ATT_USE_EXPRESSIONS = "use-expressions";
    private static final String ATT_ACCESS_DECISION_MANAGER_REF = "access-decision-manager-ref";
    private static final String ATT_OBSERVATION_REGISTRY_REF = "observation-registry-ref";
    private static final String ATT_HTTP_METHOD = "method";
    private static final String ATT_PATTERN = "pattern";
    private static final String ATT_ACCESS = "access";
    private static final String ATT_SERVLET_PATH = "servlet-path";
    private static final String ATT_FILTER_ALL_DISPATCHER_TYPES = "filter-all-dispatcher-types";
    private String authorizationManagerRef;
    private final BeanMetadataElement securityContextHolderStrategy;

    AuthorizationFilterParser(BeanMetadataElement securityContextHolderStrategy) {
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        if (!this.isUseExpressions(element)) {
            parserContext.getReaderContext().error("AuthorizationManager must be used with `use-expressions=\"true\"; either add `use-authorization-manager=\"false\"` or `use-expressions=`\"false\"` in your `<http>` block", (Object)element);
            return null;
        }
        if (StringUtils.hasText((String)element.getAttribute(ATT_ACCESS_DECISION_MANAGER_REF))) {
            parserContext.getReaderContext().error("AuthorizationManager cannot be used in conjunction with `access-decision-manager-ref`; either remove the reference to AccessDecisionManager or add `use-authorization-manager=\"false\"` to your `<http>` block", (Object)element);
            return null;
        }
        this.authorizationManagerRef = this.createAuthorizationManager(element, parserContext);
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationFilter.class);
        filterBuilder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        filterBuilder.addConstructorArgReference(this.authorizationManagerRef);
        if ("false".equals(element.getAttribute(ATT_FILTER_ALL_DISPATCHER_TYPES))) {
            filterBuilder.addPropertyValue("shouldFilterAllDispatcherTypes", (Object)Boolean.FALSE);
        }
        AbstractBeanDefinition filter = filterBuilder.addPropertyValue("securityContextHolderStrategy", (Object)this.securityContextHolderStrategy).getBeanDefinition();
        String id = element.getAttribute("id");
        if (StringUtils.hasText((String)id)) {
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)filter, id));
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)filter);
        }
        return filter;
    }

    String getAuthorizationManagerRef() {
        return this.authorizationManagerRef;
    }

    private String createAuthorizationManager(Element element, ParserContext parserContext) {
        String expressionHandlerRef;
        XmlReaderContext context = parserContext.getReaderContext();
        String authorizationManagerRef = element.getAttribute("authorization-manager-ref");
        if (StringUtils.hasText((String)authorizationManagerRef)) {
            return authorizationManagerRef;
        }
        Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)element, (String)"expression-handler");
        String string = expressionHandlerRef = expressionHandlerElt != null ? expressionHandlerElt.getAttribute("ref") : null;
        if (expressionHandlerRef == null) {
            expressionHandlerRef = this.registerDefaultExpressionHandler(parserContext);
        }
        MatcherType matcherType = MatcherType.fromElementOrMvc(element);
        ManagedMap matcherToExpression = new ManagedMap();
        List interceptMessages = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        for (Element interceptMessage : interceptMessages) {
            String accessExpression = interceptMessage.getAttribute(ATT_ACCESS);
            BeanDefinitionBuilder authorizationManager = BeanDefinitionBuilder.rootBeanDefinition(WebExpressionAuthorizationManager.class);
            authorizationManager.addPropertyReference("expressionHandler", expressionHandlerRef);
            authorizationManager.addConstructorArgValue((Object)accessExpression);
            BeanMetadataElement matcher = this.createMatcher(matcherType, interceptMessage, parserContext);
            matcherToExpression.put((Object)matcher, (Object)authorizationManager.getBeanDefinition());
        }
        BeanDefinitionBuilder mds = BeanDefinitionBuilder.rootBeanDefinition(RequestMatcherDelegatingAuthorizationManagerFactory.class).addPropertyValue("requestMatcherMap", (Object)matcherToExpression).addPropertyValue("observationRegistry", (Object)this.getObservationRegistry(element));
        return context.registerWithGeneratedName((BeanDefinition)mds.getBeanDefinition());
    }

    private BeanMetadataElement createMatcher(MatcherType matcherType, Element urlElt, ParserContext parserContext) {
        String servletPath;
        String method;
        String path = urlElt.getAttribute(ATT_PATTERN);
        String matcherRef = urlElt.getAttribute("request-matcher-ref");
        boolean hasMatcherRef = StringUtils.hasText((String)matcherRef);
        if (!hasMatcherRef && !StringUtils.hasText((String)path)) {
            parserContext.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
        }
        if (!StringUtils.hasText((String)(method = urlElt.getAttribute(ATT_HTTP_METHOD)))) {
            method = null;
        }
        if (!StringUtils.hasText((String)(servletPath = urlElt.getAttribute(ATT_SERVLET_PATH)))) {
            servletPath = null;
        } else if (!MatcherType.path.equals((Object)matcherType)) {
            parserContext.getReaderContext().error("servlet-path is not applicable for request-matcher: '" + matcherType.name() + "'", (Object)urlElt);
        }
        return hasMatcherRef ? new RuntimeBeanReference(matcherRef) : matcherType.createMatcher(parserContext, path, method, servletPath);
    }

    String registerDefaultExpressionHandler(ParserContext pc) {
        RootBeanDefinition expressionHandler = GrantedAuthorityDefaultsParserUtils.registerWithDefaultRolePrefix(pc, DefaultWebSecurityExpressionHandlerBeanFactory.class);
        String expressionHandlerRef = pc.getReaderContext().generateBeanName((BeanDefinition)expressionHandler);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)expressionHandler, expressionHandlerRef));
        return expressionHandlerRef;
    }

    boolean isUseExpressions(Element elt) {
        String useExpressions = elt.getAttribute(ATT_USE_EXPRESSIONS);
        return !StringUtils.hasText((String)useExpressions) || "true".equals(useExpressions);
    }

    private BeanMetadataElement getObservationRegistry(Element methodSecurityElmt) {
        String holderStrategyRef = methodSecurityElmt.getAttribute(ATT_OBSERVATION_REGISTRY_REF);
        if (StringUtils.hasText((String)holderStrategyRef)) {
            return new RuntimeBeanReference(holderStrategyRef);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(ObservationRegistryFactory.class).getBeanDefinition();
    }

    public static final class RequestMatcherDelegatingAuthorizationManagerFactory
    implements FactoryBean<AuthorizationManager<HttpServletRequest>> {
        private Map<RequestMatcher, AuthorizationManager<RequestAuthorizationContext>> beans;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        public AuthorizationManager<HttpServletRequest> getObject() throws Exception {
            RequestMatcherDelegatingAuthorizationManager.Builder builder = RequestMatcherDelegatingAuthorizationManager.builder();
            for (Map.Entry<RequestMatcher, AuthorizationManager<RequestAuthorizationContext>> entry : this.beans.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            RequestMatcherDelegatingAuthorizationManager manager = builder.build();
            if (!this.observationRegistry.isNoop()) {
                return new ObservationAuthorizationManager(this.observationRegistry, (AuthorizationManager)manager);
            }
            return manager;
        }

        public Class<?> getObjectType() {
            return AuthorizationManager.class;
        }

        public void setRequestMatcherMap(Map<RequestMatcher, AuthorizationManager<RequestAuthorizationContext>> beans) {
            this.beans = beans;
        }

        public void setObservationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
        }
    }

    static class DefaultWebSecurityExpressionHandlerBeanFactory
    extends GrantedAuthorityDefaultsParserUtils.AbstractGrantedAuthorityDefaultsBeanFactory {
        private DefaultHttpSecurityExpressionHandler handler = new DefaultHttpSecurityExpressionHandler();

        DefaultWebSecurityExpressionHandlerBeanFactory() {
        }

        public DefaultHttpSecurityExpressionHandler getBean() {
            if (this.rolePrefix != null) {
                this.handler.setDefaultRolePrefix(this.rolePrefix);
            }
            return this.handler;
        }
    }

    static class ObservationRegistryFactory
    implements FactoryBean<ObservationRegistry> {
        ObservationRegistryFactory() {
        }

        public ObservationRegistry getObject() throws Exception {
            return ObservationRegistry.NOOP;
        }

        public Class<?> getObjectType() {
            return ObservationRegistry.class;
        }
    }
}

