/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.remote.VersionNegotiator;

public class StandardVersionNegotiator
implements VersionNegotiator {
    private final List<Integer> versions;
    private int curVersion;

    public StandardVersionNegotiator(int ... supportedVersions) {
        if (Objects.requireNonNull(supportedVersions).length == 0) {
            throw new IllegalArgumentException("At least one version must be supported");
        }
        ArrayList<Integer> supported = new ArrayList<Integer>();
        for (int version : supportedVersions) {
            supported.add(version);
        }
        this.versions = Collections.unmodifiableList(supported);
        this.curVersion = supportedVersions[0];
    }

    @Override
    public int getVersion() {
        return this.curVersion;
    }

    @Override
    public void setVersion(int version) throws IllegalArgumentException {
        if (!this.isVersionSupported(version)) {
            throw new IllegalArgumentException("Version " + version + " is not supported");
        }
        this.curVersion = version;
    }

    @Override
    public int getPreferredVersion() {
        return this.versions.get(0);
    }

    @Override
    public Integer getPreferredVersion(int maxVersion) {
        for (Integer version : this.versions) {
            if (maxVersion < version) continue;
            return version;
        }
        return null;
    }

    @Override
    public boolean isVersionSupported(int version) {
        return this.versions.contains(version);
    }

    @Override
    public List<Integer> getSupportedVersions() {
        return this.versions;
    }
}

