/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class DownloadBundle
extends AbstractNiFiRegistryCommand<VoidResult> {
    public DownloadBundle() {
        super("download-bundle", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Downloads the binary content of the given version of the extension bundle.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_NAME.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_GROUP.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_ARTIFACT.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_VERSION.createOption());
        this.addOption(CommandOption.OUTPUT_DIR.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String bucketName = this.getRequiredArg(properties, CommandOption.BUCKET_NAME);
        String groupId = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_GROUP);
        String artifactId = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_ARTIFACT);
        String version = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_VERSION);
        File outputDir = new File(this.getRequiredArg(properties, CommandOption.OUTPUT_DIR));
        ExtensionRepoClient repoClient = client.getExtensionRepoClient();
        repoClient.writeBundleVersionContent(bucketName, groupId, artifactId, version, outputDir);
        return VoidResult.getInstance();
    }
}

