/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRequestOptions;
import org.springframework.security.web.webauthn.authentication.PublicKeyCredentialRequestOptionsRepository;
import org.springframework.util.Assert;

public class HttpSessionPublicKeyCredentialRequestOptionsRepository
implements PublicKeyCredentialRequestOptionsRepository {
    static final String DEFAULT_ATTR_NAME = PublicKeyCredentialRequestOptionsRepository.class.getName().concat(".ATTR_NAME");
    private String attrName = DEFAULT_ATTR_NAME;

    @Override
    public void save(HttpServletRequest request, HttpServletResponse response, PublicKeyCredentialRequestOptions options) {
        HttpSession session = request.getSession();
        session.setAttribute(this.attrName, (Object)options);
    }

    @Override
    public PublicKeyCredentialRequestOptions load(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (PublicKeyCredentialRequestOptions)session.getAttribute(this.attrName);
    }

    public void setAttrName(String attrName) {
        Assert.notNull((Object)attrName, (String)"attrName cannot be null");
        this.attrName = attrName;
    }
}

