/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LoginUrlAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private static final Log logger = LogFactory.getLog(LoginUrlAuthenticationEntryPoint.class);
    private PortMapper portMapper = new PortMapperImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private String loginFormUrl;
    private boolean forceHttps = false;
    private boolean useForward = false;
    private boolean favorRelativeUris = false;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public LoginUrlAuthenticationEntryPoint(String loginFormUrl) {
        Assert.notNull((Object)loginFormUrl, (String)"loginFormUrl cannot be null");
        this.loginFormUrl = loginFormUrl;
    }

    public void afterPropertiesSet() {
        Assert.isTrue((StringUtils.hasText((String)this.loginFormUrl) && UrlUtils.isValidRedirectUrl(this.loginFormUrl) ? 1 : 0) != 0, (String)"loginFormUrl must be specified and must be a valid redirect URL");
        Assert.isTrue((!this.useForward || !UrlUtils.isAbsoluteUrl(this.loginFormUrl) ? 1 : 0) != 0, (String)"useForward must be false if using an absolute loginFormURL");
        Assert.notNull((Object)this.portMapper, (String)"portMapper must be specified");
        Assert.notNull((Object)this.portResolver, (String)"portResolver must be specified");
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        return this.getLoginFormUrl();
    }

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (!this.useForward) {
            String redirectUrl = this.buildRedirectUrlToLoginPage(request, response, authException);
            this.redirectStrategy.sendRedirect(request, response, redirectUrl);
            return;
        }
        String redirectUrl = null;
        if (this.forceHttps && "http".equals(request.getScheme())) {
            redirectUrl = this.buildHttpsRedirectUrlForRequest(request);
        }
        if (redirectUrl != null) {
            this.redirectStrategy.sendRedirect(request, response, redirectUrl);
            return;
        }
        String loginForm = this.determineUrlToUseForThisRequest(request, response, authException);
        logger.debug((Object)LogMessage.format((String)"Server side forward to: %s", (Object)loginForm));
        RequestDispatcher dispatcher = request.getRequestDispatcher(loginForm);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected String buildRedirectUrlToLoginPage(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) {
        String loginForm = this.determineUrlToUseForThisRequest(request, response, authException);
        if (UrlUtils.isAbsoluteUrl(loginForm)) {
            return loginForm;
        }
        if (this.requiresRewrite(request)) {
            return this.httpsUri(request, loginForm);
        }
        return this.favorRelativeUris ? loginForm : this.absoluteUri(request, loginForm).getUrl();
    }

    private boolean requiresRewrite(HttpServletRequest request) {
        return this.forceHttps && "http".equals(request.getScheme());
    }

    private String httpsUri(HttpServletRequest request, String path) {
        int serverPort = this.portResolver.getServerPort((ServletRequest)request);
        Integer httpsPort = this.portMapper.lookupHttpsPort(serverPort);
        if (httpsPort == null) {
            logger.warn((Object)LogMessage.format((String)"Unable to redirect to HTTPS as no port mapping found for HTTP port %s", (Object)serverPort));
            return this.favorRelativeUris ? path : this.absoluteUri(request, path).getUrl();
        }
        RedirectUrlBuilder builder = this.absoluteUri(request, path);
        builder.setScheme("https");
        builder.setPort(httpsPort);
        return builder.getUrl();
    }

    private RedirectUrlBuilder absoluteUri(HttpServletRequest request, String path) {
        RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
        urlBuilder.setScheme(request.getScheme());
        urlBuilder.setServerName(request.getServerName());
        urlBuilder.setPort(this.portResolver.getServerPort((ServletRequest)request));
        urlBuilder.setContextPath(request.getContextPath());
        urlBuilder.setPathInfo(path);
        return urlBuilder;
    }

    protected String buildHttpsRedirectUrlForRequest(HttpServletRequest request) throws IOException, ServletException {
        int serverPort = this.portResolver.getServerPort((ServletRequest)request);
        Integer httpsPort = this.portMapper.lookupHttpsPort(serverPort);
        if (httpsPort != null) {
            RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
            urlBuilder.setScheme("https");
            urlBuilder.setServerName(request.getServerName());
            urlBuilder.setPort(httpsPort);
            urlBuilder.setContextPath(request.getContextPath());
            urlBuilder.setServletPath(request.getServletPath());
            urlBuilder.setPathInfo(request.getPathInfo());
            urlBuilder.setQuery(request.getQueryString());
            return urlBuilder.getUrl();
        }
        logger.warn((Object)LogMessage.format((String)"Unable to redirect to HTTPS as no port mapping found for HTTP port %s", (Object)serverPort));
        return null;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    protected boolean isForceHttps() {
        return this.forceHttps;
    }

    public String getLoginFormUrl() {
        return this.loginFormUrl;
    }

    public void setPortMapper(PortMapper portMapper) {
        Assert.notNull((Object)portMapper, (String)"portMapper cannot be null");
        this.portMapper = portMapper;
    }

    protected PortMapper getPortMapper() {
        return this.portMapper;
    }

    @Deprecated(forRemoval=true)
    public void setPortResolver(PortResolver portResolver) {
        Assert.notNull((Object)portResolver, (String)"portResolver cannot be null");
        this.portResolver = portResolver;
    }

    @Deprecated(forRemoval=true)
    protected PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void setUseForward(boolean useForward) {
        this.useForward = useForward;
    }

    protected boolean isUseForward() {
        return this.useForward;
    }

    public void setFavorRelativeUris(boolean favorRelativeUris) {
        this.favorRelativeUris = favorRelativeUris;
    }
}

